#[doc = "Register `CLKCR` reader"]
pub struct R(crate::R<CLKCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CLKCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CLKCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CLKCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CLKCR` writer"]
pub struct W(crate::W<CLKCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CLKCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CLKCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CLKCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CKSEL` reader - Clock Select Bits"]
pub struct CKSEL_R(crate::FieldReader<u8, u8>);
impl CKSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CKSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKSEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKSEL` writer - Clock Select Bits"]
pub struct CKSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CKSEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `SUT` reader - Start-up Time"]
pub struct SUT_R(crate::FieldReader<bool, bool>);
impl SUT_R {
    pub(crate) fn new(bits: bool) -> Self {
        SUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUT` writer - Start-up Time"]
pub struct SUT_W<'a> {
    w: &'a mut W,
}
impl<'a> SUT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `CKOUTC` reader - Clock Output (Copy). Active low."]
pub struct CKOUTC_R(crate::FieldReader<bool, bool>);
impl CKOUTC_R {
    pub(crate) fn new(bits: bool) -> Self {
        CKOUTC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKOUTC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKOUTC` writer - Clock Output (Copy). Active low."]
pub struct CKOUTC_W<'a> {
    w: &'a mut W,
}
impl<'a> CKOUTC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `CSTR` reader - Clock Switch Trigger"]
pub struct CSTR_R(crate::FieldReader<bool, bool>);
impl CSTR_R {
    pub(crate) fn new(bits: bool) -> Self {
        CSTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CSTR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSTR` writer - Clock Switch Trigger"]
pub struct CSTR_W<'a> {
    w: &'a mut W,
}
impl<'a> CSTR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `OSCRDY` reader - Oscillator Ready"]
pub struct OSCRDY_R(crate::FieldReader<bool, bool>);
impl OSCRDY_R {
    pub(crate) fn new(bits: bool) -> Self {
        OSCRDY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OSCRDY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OSCRDY` writer - Oscillator Ready"]
pub struct OSCRDY_W<'a> {
    w: &'a mut W,
}
impl<'a> OSCRDY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Clock Select Bits"]
    #[inline(always)]
    pub fn cksel(&self) -> CKSEL_R {
        CKSEL_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bit 4 - Start-up Time"]
    #[inline(always)]
    pub fn sut(&self) -> SUT_R {
        SUT_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Clock Output (Copy). Active low."]
    #[inline(always)]
    pub fn ckoutc(&self) -> CKOUTC_R {
        CKOUTC_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Clock Switch Trigger"]
    #[inline(always)]
    pub fn cstr(&self) -> CSTR_R {
        CSTR_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Oscillator Ready"]
    #[inline(always)]
    pub fn oscrdy(&self) -> OSCRDY_R {
        OSCRDY_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Clock Select Bits"]
    #[inline(always)]
    pub fn cksel(&mut self) -> CKSEL_W {
        CKSEL_W { w: self }
    }
    #[doc = "Bit 4 - Start-up Time"]
    #[inline(always)]
    pub fn sut(&mut self) -> SUT_W {
        SUT_W { w: self }
    }
    #[doc = "Bit 5 - Clock Output (Copy). Active low."]
    #[inline(always)]
    pub fn ckoutc(&mut self) -> CKOUTC_W {
        CKOUTC_W { w: self }
    }
    #[doc = "Bit 6 - Clock Switch Trigger"]
    #[inline(always)]
    pub fn cstr(&mut self) -> CSTR_W {
        CSTR_W { w: self }
    }
    #[doc = "Bit 7 - Oscillator Ready"]
    #[inline(always)]
    pub fn oscrdy(&mut self) -> OSCRDY_W {
        OSCRDY_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [clkcr](index.html) module"]
pub struct CLKCR_SPEC;
impl crate::RegisterSpec for CLKCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [clkcr::R](R) reader structure"]
impl crate::Readable for CLKCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [clkcr::W](W) writer structure"]
impl crate::Writable for CLKCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CLKCR to value 0"]
impl crate::Resettable for CLKCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
