#[doc = "Register `ADMUXB` reader"]
pub struct R(crate::R<ADMUXB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADMUXB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADMUXB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADMUXB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADMUXB` writer"]
pub struct W(crate::W<ADMUXB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADMUXB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADMUXB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADMUXB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GSEL` reader - Gain Selection Bits"]
pub struct GSEL_R(crate::FieldReader<u8, u8>);
impl GSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        GSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GSEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GSEL` writer - Gain Selection Bits"]
pub struct GSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> GSEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Reference Selection Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum REFS_A {
    #[doc = "0: Vcc"]
    VCC = 0,
    #[doc = "1: Internal 1.1V Voltage Reference with AREF disconnected"]
    INTERNAL_1 = 1,
    #[doc = "2: Internal 2.2V Voltage Reference with AREF disconnected"]
    INTERNAL_2 = 2,
    #[doc = "3: Internal 4.096V Voltage Reference with AREF disconnected"]
    INTERNAL_4 = 3,
    #[doc = "4: AREF with internal reference off"]
    AREF = 4,
    #[doc = "5: Internal 1.1V Voltage Reference with external capacitor at AREF pin"]
    AREF_INTERNAL_1 = 5,
    #[doc = "6: Internal 2.2V Voltage Reference with external capacitor at AREF pin"]
    AREF_INTERNAL_2 = 6,
    #[doc = "7: Internal 4.096V Voltage Reference with external capacitor at AREF pin"]
    AREF_INTERNAL_4 = 7,
}
impl From<REFS_A> for u8 {
    #[inline(always)]
    fn from(variant: REFS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `REFS` reader - Reference Selection Bits"]
pub struct REFS_R(crate::FieldReader<u8, REFS_A>);
impl REFS_R {
    pub(crate) fn new(bits: u8) -> Self {
        REFS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> REFS_A {
        match self.bits {
            0 => REFS_A::VCC,
            1 => REFS_A::INTERNAL_1,
            2 => REFS_A::INTERNAL_2,
            3 => REFS_A::INTERNAL_4,
            4 => REFS_A::AREF,
            5 => REFS_A::AREF_INTERNAL_1,
            6 => REFS_A::AREF_INTERNAL_2,
            7 => REFS_A::AREF_INTERNAL_4,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VCC`"]
    #[inline(always)]
    pub fn is_vcc(&self) -> bool {
        **self == REFS_A::VCC
    }
    #[doc = "Checks if the value of the field is `INTERNAL_1`"]
    #[inline(always)]
    pub fn is_internal_1(&self) -> bool {
        **self == REFS_A::INTERNAL_1
    }
    #[doc = "Checks if the value of the field is `INTERNAL_2`"]
    #[inline(always)]
    pub fn is_internal_2(&self) -> bool {
        **self == REFS_A::INTERNAL_2
    }
    #[doc = "Checks if the value of the field is `INTERNAL_4`"]
    #[inline(always)]
    pub fn is_internal_4(&self) -> bool {
        **self == REFS_A::INTERNAL_4
    }
    #[doc = "Checks if the value of the field is `AREF`"]
    #[inline(always)]
    pub fn is_aref(&self) -> bool {
        **self == REFS_A::AREF
    }
    #[doc = "Checks if the value of the field is `AREF_INTERNAL_1`"]
    #[inline(always)]
    pub fn is_aref_internal_1(&self) -> bool {
        **self == REFS_A::AREF_INTERNAL_1
    }
    #[doc = "Checks if the value of the field is `AREF_INTERNAL_2`"]
    #[inline(always)]
    pub fn is_aref_internal_2(&self) -> bool {
        **self == REFS_A::AREF_INTERNAL_2
    }
    #[doc = "Checks if the value of the field is `AREF_INTERNAL_4`"]
    #[inline(always)]
    pub fn is_aref_internal_4(&self) -> bool {
        **self == REFS_A::AREF_INTERNAL_4
    }
}
impl core::ops::Deref for REFS_R {
    type Target = crate::FieldReader<u8, REFS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REFS` writer - Reference Selection Bits"]
pub struct REFS_W<'a> {
    w: &'a mut W,
}
impl<'a> REFS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: REFS_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Vcc"]
    #[inline(always)]
    pub fn vcc(self) -> &'a mut W {
        self.variant(REFS_A::VCC)
    }
    #[doc = "Internal 1.1V Voltage Reference with AREF disconnected"]
    #[inline(always)]
    pub fn internal_1(self) -> &'a mut W {
        self.variant(REFS_A::INTERNAL_1)
    }
    #[doc = "Internal 2.2V Voltage Reference with AREF disconnected"]
    #[inline(always)]
    pub fn internal_2(self) -> &'a mut W {
        self.variant(REFS_A::INTERNAL_2)
    }
    #[doc = "Internal 4.096V Voltage Reference with AREF disconnected"]
    #[inline(always)]
    pub fn internal_4(self) -> &'a mut W {
        self.variant(REFS_A::INTERNAL_4)
    }
    #[doc = "AREF with internal reference off"]
    #[inline(always)]
    pub fn aref(self) -> &'a mut W {
        self.variant(REFS_A::AREF)
    }
    #[doc = "Internal 1.1V Voltage Reference with external capacitor at AREF pin"]
    #[inline(always)]
    pub fn aref_internal_1(self) -> &'a mut W {
        self.variant(REFS_A::AREF_INTERNAL_1)
    }
    #[doc = "Internal 2.2V Voltage Reference with external capacitor at AREF pin"]
    #[inline(always)]
    pub fn aref_internal_2(self) -> &'a mut W {
        self.variant(REFS_A::AREF_INTERNAL_2)
    }
    #[doc = "Internal 4.096V Voltage Reference with external capacitor at AREF pin"]
    #[inline(always)]
    pub fn aref_internal_4(self) -> &'a mut W {
        self.variant(REFS_A::AREF_INTERNAL_4)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Gain Selection Bits"]
    #[inline(always)]
    pub fn gsel(&self) -> GSEL_R {
        GSEL_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 5:7 - Reference Selection Bits"]
    #[inline(always)]
    pub fn refs(&self) -> REFS_R {
        REFS_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Gain Selection Bits"]
    #[inline(always)]
    pub fn gsel(&mut self) -> GSEL_W {
        GSEL_W { w: self }
    }
    #[doc = "Bits 5:7 - Reference Selection Bits"]
    #[inline(always)]
    pub fn refs(&mut self) -> REFS_W {
        REFS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The ADC multiplexer Selection Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [admuxb](index.html) module"]
pub struct ADMUXB_SPEC;
impl crate::RegisterSpec for ADMUXB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [admuxb::R](R) reader structure"]
impl crate::Readable for ADMUXB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [admuxb::W](W) writer structure"]
impl crate::Writable for ADMUXB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADMUXB to value 0"]
impl crate::Resettable for ADMUXB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
