#[doc = "Register `ACSR1B` reader"]
pub struct R(crate::R<ACSR1B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ACSR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ACSR1B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ACSR1B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ACSR1B` writer"]
pub struct W(crate::W<ACSR1B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ACSR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ACSR1B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ACSR1B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ACME1` reader - Analog Comparator 1 Multiplexer Enable"]
pub struct ACME1_R(crate::FieldReader<bool, bool>);
impl ACME1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACME1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACME1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACME1` writer - Analog Comparator 1 Multiplexer Enable"]
pub struct ACME1_W<'a> {
    w: &'a mut W,
}
impl<'a> ACME1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ACOE1` reader - Analog Comparator 1 Output Pin Enable"]
pub struct ACOE1_R(crate::FieldReader<bool, bool>);
impl ACOE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACOE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACOE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACOE1` writer - Analog Comparator 1 Output Pin Enable"]
pub struct ACOE1_W<'a> {
    w: &'a mut W,
}
impl<'a> ACOE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `HLEV1` reader - Analog Comparator 1 Hysteresis Level"]
pub struct HLEV1_R(crate::FieldReader<bool, bool>);
impl HLEV1_R {
    pub(crate) fn new(bits: bool) -> Self {
        HLEV1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HLEV1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HLEV1` writer - Analog Comparator 1 Hysteresis Level"]
pub struct HLEV1_W<'a> {
    w: &'a mut W,
}
impl<'a> HLEV1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `HSEL1` reader - Analog Comparator 1 Hysteresis Select"]
pub struct HSEL1_R(crate::FieldReader<bool, bool>);
impl HSEL1_R {
    pub(crate) fn new(bits: bool) -> Self {
        HSEL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HSEL1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HSEL1` writer - Analog Comparator 1 Hysteresis Select"]
pub struct HSEL1_W<'a> {
    w: &'a mut W,
}
impl<'a> HSEL1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Analog Comparator 1 Multiplexer Enable"]
    #[inline(always)]
    pub fn acme1(&self) -> ACME1_R {
        ACME1_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Analog Comparator 1 Output Pin Enable"]
    #[inline(always)]
    pub fn acoe1(&self) -> ACOE1_R {
        ACOE1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Analog Comparator 1 Hysteresis Level"]
    #[inline(always)]
    pub fn hlev1(&self) -> HLEV1_R {
        HLEV1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Analog Comparator 1 Hysteresis Select"]
    #[inline(always)]
    pub fn hsel1(&self) -> HSEL1_R {
        HSEL1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Analog Comparator 1 Multiplexer Enable"]
    #[inline(always)]
    pub fn acme1(&mut self) -> ACME1_W {
        ACME1_W { w: self }
    }
    #[doc = "Bit 4 - Analog Comparator 1 Output Pin Enable"]
    #[inline(always)]
    pub fn acoe1(&mut self) -> ACOE1_W {
        ACOE1_W { w: self }
    }
    #[doc = "Bit 6 - Analog Comparator 1 Hysteresis Level"]
    #[inline(always)]
    pub fn hlev1(&mut self) -> HLEV1_W {
        HLEV1_W { w: self }
    }
    #[doc = "Bit 7 - Analog Comparator 1 Hysteresis Select"]
    #[inline(always)]
    pub fn hsel1(&mut self) -> HSEL1_W {
        HSEL1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Comparator 1 Control And Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acsr1b](index.html) module"]
pub struct ACSR1B_SPEC;
impl crate::RegisterSpec for ACSR1B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [acsr1b::R](R) reader structure"]
impl crate::Readable for ACSR1B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [acsr1b::W](W) writer structure"]
impl crate::Writable for ACSR1B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ACSR1B to value 0"]
impl crate::Resettable for ACSR1B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
