#[doc = "Register `ACSR0B` reader"]
pub struct R(crate::R<ACSR0B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ACSR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ACSR0B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ACSR0B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ACSR0B` writer"]
pub struct W(crate::W<ACSR0B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ACSR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ACSR0B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ACSR0B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ACPMUX` reader - Analog Comparator 0 Positive Input Multiplexer Bits 1:0"]
pub struct ACPMUX_R(crate::FieldReader<u8, u8>);
impl ACPMUX_R {
    pub(crate) fn new(bits: u8) -> Self {
        ACPMUX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACPMUX_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACPMUX` writer - Analog Comparator 0 Positive Input Multiplexer Bits 1:0"]
pub struct ACPMUX_W<'a> {
    w: &'a mut W,
}
impl<'a> ACPMUX_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `ACNMUX` reader - Analog Comparator 0 Negative Input Multiplexer"]
pub struct ACNMUX_R(crate::FieldReader<u8, u8>);
impl ACNMUX_R {
    pub(crate) fn new(bits: u8) -> Self {
        ACNMUX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACNMUX_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACNMUX` writer - Analog Comparator 0 Negative Input Multiplexer"]
pub struct ACNMUX_W<'a> {
    w: &'a mut W,
}
impl<'a> ACNMUX_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `ACOE0` reader - Analog Comparator 0 Output Pin Enable"]
pub struct ACOE0_R(crate::FieldReader<bool, bool>);
impl ACOE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACOE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACOE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACOE0` writer - Analog Comparator 0 Output Pin Enable"]
pub struct ACOE0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACOE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `HLEV0` reader - Analog Comparator 0 Hysteresis Level"]
pub struct HLEV0_R(crate::FieldReader<bool, bool>);
impl HLEV0_R {
    pub(crate) fn new(bits: bool) -> Self {
        HLEV0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HLEV0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HLEV0` writer - Analog Comparator 0 Hysteresis Level"]
pub struct HLEV0_W<'a> {
    w: &'a mut W,
}
impl<'a> HLEV0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `HSEL0` reader - Analog Comparator 0 Hysteresis Select"]
pub struct HSEL0_R(crate::FieldReader<bool, bool>);
impl HSEL0_R {
    pub(crate) fn new(bits: bool) -> Self {
        HSEL0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HSEL0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HSEL0` writer - Analog Comparator 0 Hysteresis Select"]
pub struct HSEL0_W<'a> {
    w: &'a mut W,
}
impl<'a> HSEL0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Analog Comparator 0 Positive Input Multiplexer Bits 1:0"]
    #[inline(always)]
    pub fn acpmux(&self) -> ACPMUX_R {
        ACPMUX_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Analog Comparator 0 Negative Input Multiplexer"]
    #[inline(always)]
    pub fn acnmux(&self) -> ACNMUX_R {
        ACNMUX_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 4 - Analog Comparator 0 Output Pin Enable"]
    #[inline(always)]
    pub fn acoe0(&self) -> ACOE0_R {
        ACOE0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Analog Comparator 0 Hysteresis Level"]
    #[inline(always)]
    pub fn hlev0(&self) -> HLEV0_R {
        HLEV0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Analog Comparator 0 Hysteresis Select"]
    #[inline(always)]
    pub fn hsel0(&self) -> HSEL0_R {
        HSEL0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Analog Comparator 0 Positive Input Multiplexer Bits 1:0"]
    #[inline(always)]
    pub fn acpmux(&mut self) -> ACPMUX_W {
        ACPMUX_W { w: self }
    }
    #[doc = "Bits 2:3 - Analog Comparator 0 Negative Input Multiplexer"]
    #[inline(always)]
    pub fn acnmux(&mut self) -> ACNMUX_W {
        ACNMUX_W { w: self }
    }
    #[doc = "Bit 4 - Analog Comparator 0 Output Pin Enable"]
    #[inline(always)]
    pub fn acoe0(&mut self) -> ACOE0_W {
        ACOE0_W { w: self }
    }
    #[doc = "Bit 6 - Analog Comparator 0 Hysteresis Level"]
    #[inline(always)]
    pub fn hlev0(&mut self) -> HLEV0_W {
        HLEV0_W { w: self }
    }
    #[doc = "Bit 7 - Analog Comparator 0 Hysteresis Select"]
    #[inline(always)]
    pub fn hsel0(&mut self) -> HSEL0_W {
        HSEL0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Comparator 0 Control And Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acsr0b](index.html) module"]
pub struct ACSR0B_SPEC;
impl crate::RegisterSpec for ACSR0B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [acsr0b::R](R) reader structure"]
impl crate::Readable for ACSR0B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [acsr0b::W](W) writer structure"]
impl crate::Writable for ACSR0B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ACSR0B to value 0"]
impl crate::Resettable for ACSR0B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
