#[doc = "Register `SCTRLB` reader"]
pub struct R(crate::R<SCTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SCTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SCTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SCTRLB` writer"]
pub struct W(crate::W<SCTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SCTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SCTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Command\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SCMD_A {
    #[doc = "0: No Action"]
    NOACT = 0,
    #[doc = "2: Used To Complete a Transaction"]
    COMPTRANS = 2,
    #[doc = "3: Used in Response to Address/Data Interrupt"]
    RESPONSE = 3,
}
impl From<SCMD_A> for u8 {
    #[inline(always)]
    fn from(variant: SCMD_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SCMD` reader - Command"]
pub struct SCMD_R(crate::FieldReader<u8, SCMD_A>);
impl SCMD_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCMD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<SCMD_A> {
        match self.bits {
            0 => Some(SCMD_A::NOACT),
            2 => Some(SCMD_A::COMPTRANS),
            3 => Some(SCMD_A::RESPONSE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `NOACT`"]
    #[inline(always)]
    pub fn is_noact(&self) -> bool {
        **self == SCMD_A::NOACT
    }
    #[doc = "Checks if the value of the field is `COMPTRANS`"]
    #[inline(always)]
    pub fn is_comptrans(&self) -> bool {
        **self == SCMD_A::COMPTRANS
    }
    #[doc = "Checks if the value of the field is `RESPONSE`"]
    #[inline(always)]
    pub fn is_response(&self) -> bool {
        **self == SCMD_A::RESPONSE
    }
}
impl core::ops::Deref for SCMD_R {
    type Target = crate::FieldReader<u8, SCMD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCMD` writer - Command"]
pub struct SCMD_W<'a> {
    w: &'a mut W,
}
impl<'a> SCMD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SCMD_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No Action"]
    #[inline(always)]
    pub fn noact(self) -> &'a mut W {
        self.variant(SCMD_A::NOACT)
    }
    #[doc = "Used To Complete a Transaction"]
    #[inline(always)]
    pub fn comptrans(self) -> &'a mut W {
        self.variant(SCMD_A::COMPTRANS)
    }
    #[doc = "Used in Response to Address/Data Interrupt"]
    #[inline(always)]
    pub fn response(self) -> &'a mut W {
        self.variant(SCMD_A::RESPONSE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Acknowledge Action\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum ACKACT_A {
    #[doc = "0: Send ACK"]
    ACK = 0,
    #[doc = "1: Send NACK"]
    NACK = 1,
}
impl From<ACKACT_A> for bool {
    #[inline(always)]
    fn from(variant: ACKACT_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `ACKACT` reader - Acknowledge Action"]
pub struct ACKACT_R(crate::FieldReader<bool, ACKACT_A>);
impl ACKACT_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACKACT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ACKACT_A {
        match self.bits {
            false => ACKACT_A::ACK,
            true => ACKACT_A::NACK,
        }
    }
    #[doc = "Checks if the value of the field is `ACK`"]
    #[inline(always)]
    pub fn is_ack(&self) -> bool {
        **self == ACKACT_A::ACK
    }
    #[doc = "Checks if the value of the field is `NACK`"]
    #[inline(always)]
    pub fn is_nack(&self) -> bool {
        **self == ACKACT_A::NACK
    }
}
impl core::ops::Deref for ACKACT_R {
    type Target = crate::FieldReader<bool, ACKACT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACKACT` writer - Acknowledge Action"]
pub struct ACKACT_W<'a> {
    w: &'a mut W,
}
impl<'a> ACKACT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ACKACT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Send ACK"]
    #[inline(always)]
    pub fn ack(self) -> &'a mut W {
        self.variant(ACKACT_A::ACK)
    }
    #[doc = "Send NACK"]
    #[inline(always)]
    pub fn nack(self) -> &'a mut W {
        self.variant(ACKACT_A::NACK)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Command"]
    #[inline(always)]
    pub fn scmd(&self) -> SCMD_R {
        SCMD_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Acknowledge Action"]
    #[inline(always)]
    pub fn ackact(&self) -> ACKACT_R {
        ACKACT_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Command"]
    #[inline(always)]
    pub fn scmd(&mut self) -> SCMD_W {
        SCMD_W { w: self }
    }
    #[doc = "Bit 2 - Acknowledge Action"]
    #[inline(always)]
    pub fn ackact(&mut self) -> ACKACT_W {
        ACKACT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Slave Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sctrlb](index.html) module"]
pub struct SCTRLB_SPEC;
impl crate::RegisterSpec for SCTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [sctrlb::R](R) reader structure"]
impl crate::Readable for SCTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sctrlb::W](W) writer structure"]
impl crate::Writable for SCTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SCTRLB to value 0"]
impl crate::Resettable for SCTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
