#[doc = "Register `INPUTCTRLB` reader"]
pub struct R(crate::R<INPUTCTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INPUTCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INPUTCTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INPUTCTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INPUTCTRLB` writer"]
pub struct W(crate::W<INPUTCTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INPUTCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INPUTCTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INPUTCTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Input mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum INPUTMODE_A {
    #[doc = "0: Input has no actions"]
    NONE = 0,
    #[doc = "1: Stop output, jump to opposite compare cycle and wait"]
    JMPWAIT = 1,
    #[doc = "2: Stop output, execute opposite compare cycle and wait"]
    EXECWAIT = 2,
    #[doc = "3: stop output, execute opposite compare cycle while fault active"]
    EXECFAULT = 3,
    #[doc = "4: Stop all outputs, maintain frequency"]
    FREQ = 4,
    #[doc = "5: Stop all outputs, execute dead time while fault active"]
    EXECDT = 5,
    #[doc = "6: Stop all outputs, jump to next compare cycle and wait"]
    WAIT = 6,
    #[doc = "7: Stop all outputs, wait for software action"]
    WAITSW = 7,
    #[doc = "8: Stop output on edge, jump to next compare cycle"]
    EDGETRIG = 8,
    #[doc = "9: Stop output on edge, maintain frequency"]
    EDGETRIGFREQ = 9,
    #[doc = "10: Stop output at level, maintain frequency"]
    LVLTRIGFREQ = 10,
}
impl From<INPUTMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: INPUTMODE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `INPUTMODE` reader - Input mode"]
pub struct INPUTMODE_R(crate::FieldReader<u8, INPUTMODE_A>);
impl INPUTMODE_R {
    pub(crate) fn new(bits: u8) -> Self {
        INPUTMODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<INPUTMODE_A> {
        match self.bits {
            0 => Some(INPUTMODE_A::NONE),
            1 => Some(INPUTMODE_A::JMPWAIT),
            2 => Some(INPUTMODE_A::EXECWAIT),
            3 => Some(INPUTMODE_A::EXECFAULT),
            4 => Some(INPUTMODE_A::FREQ),
            5 => Some(INPUTMODE_A::EXECDT),
            6 => Some(INPUTMODE_A::WAIT),
            7 => Some(INPUTMODE_A::WAITSW),
            8 => Some(INPUTMODE_A::EDGETRIG),
            9 => Some(INPUTMODE_A::EDGETRIGFREQ),
            10 => Some(INPUTMODE_A::LVLTRIGFREQ),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `NONE`"]
    #[inline(always)]
    pub fn is_none(&self) -> bool {
        **self == INPUTMODE_A::NONE
    }
    #[doc = "Checks if the value of the field is `JMPWAIT`"]
    #[inline(always)]
    pub fn is_jmpwait(&self) -> bool {
        **self == INPUTMODE_A::JMPWAIT
    }
    #[doc = "Checks if the value of the field is `EXECWAIT`"]
    #[inline(always)]
    pub fn is_execwait(&self) -> bool {
        **self == INPUTMODE_A::EXECWAIT
    }
    #[doc = "Checks if the value of the field is `EXECFAULT`"]
    #[inline(always)]
    pub fn is_execfault(&self) -> bool {
        **self == INPUTMODE_A::EXECFAULT
    }
    #[doc = "Checks if the value of the field is `FREQ`"]
    #[inline(always)]
    pub fn is_freq(&self) -> bool {
        **self == INPUTMODE_A::FREQ
    }
    #[doc = "Checks if the value of the field is `EXECDT`"]
    #[inline(always)]
    pub fn is_execdt(&self) -> bool {
        **self == INPUTMODE_A::EXECDT
    }
    #[doc = "Checks if the value of the field is `WAIT`"]
    #[inline(always)]
    pub fn is_wait(&self) -> bool {
        **self == INPUTMODE_A::WAIT
    }
    #[doc = "Checks if the value of the field is `WAITSW`"]
    #[inline(always)]
    pub fn is_waitsw(&self) -> bool {
        **self == INPUTMODE_A::WAITSW
    }
    #[doc = "Checks if the value of the field is `EDGETRIG`"]
    #[inline(always)]
    pub fn is_edgetrig(&self) -> bool {
        **self == INPUTMODE_A::EDGETRIG
    }
    #[doc = "Checks if the value of the field is `EDGETRIGFREQ`"]
    #[inline(always)]
    pub fn is_edgetrigfreq(&self) -> bool {
        **self == INPUTMODE_A::EDGETRIGFREQ
    }
    #[doc = "Checks if the value of the field is `LVLTRIGFREQ`"]
    #[inline(always)]
    pub fn is_lvltrigfreq(&self) -> bool {
        **self == INPUTMODE_A::LVLTRIGFREQ
    }
}
impl core::ops::Deref for INPUTMODE_R {
    type Target = crate::FieldReader<u8, INPUTMODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INPUTMODE` writer - Input mode"]
pub struct INPUTMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> INPUTMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INPUTMODE_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Input has no actions"]
    #[inline(always)]
    pub fn none(self) -> &'a mut W {
        self.variant(INPUTMODE_A::NONE)
    }
    #[doc = "Stop output, jump to opposite compare cycle and wait"]
    #[inline(always)]
    pub fn jmpwait(self) -> &'a mut W {
        self.variant(INPUTMODE_A::JMPWAIT)
    }
    #[doc = "Stop output, execute opposite compare cycle and wait"]
    #[inline(always)]
    pub fn execwait(self) -> &'a mut W {
        self.variant(INPUTMODE_A::EXECWAIT)
    }
    #[doc = "stop output, execute opposite compare cycle while fault active"]
    #[inline(always)]
    pub fn execfault(self) -> &'a mut W {
        self.variant(INPUTMODE_A::EXECFAULT)
    }
    #[doc = "Stop all outputs, maintain frequency"]
    #[inline(always)]
    pub fn freq(self) -> &'a mut W {
        self.variant(INPUTMODE_A::FREQ)
    }
    #[doc = "Stop all outputs, execute dead time while fault active"]
    #[inline(always)]
    pub fn execdt(self) -> &'a mut W {
        self.variant(INPUTMODE_A::EXECDT)
    }
    #[doc = "Stop all outputs, jump to next compare cycle and wait"]
    #[inline(always)]
    pub fn wait(self) -> &'a mut W {
        self.variant(INPUTMODE_A::WAIT)
    }
    #[doc = "Stop all outputs, wait for software action"]
    #[inline(always)]
    pub fn waitsw(self) -> &'a mut W {
        self.variant(INPUTMODE_A::WAITSW)
    }
    #[doc = "Stop output on edge, jump to next compare cycle"]
    #[inline(always)]
    pub fn edgetrig(self) -> &'a mut W {
        self.variant(INPUTMODE_A::EDGETRIG)
    }
    #[doc = "Stop output on edge, maintain frequency"]
    #[inline(always)]
    pub fn edgetrigfreq(self) -> &'a mut W {
        self.variant(INPUTMODE_A::EDGETRIGFREQ)
    }
    #[doc = "Stop output at level, maintain frequency"]
    #[inline(always)]
    pub fn lvltrigfreq(self) -> &'a mut W {
        self.variant(INPUTMODE_A::LVLTRIGFREQ)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Input mode"]
    #[inline(always)]
    pub fn inputmode(&self) -> INPUTMODE_R {
        INPUTMODE_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:3 - Input mode"]
    #[inline(always)]
    pub fn inputmode(&mut self) -> INPUTMODE_W {
        INPUTMODE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Input Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [inputctrlb](index.html) module"]
pub struct INPUTCTRLB_SPEC;
impl crate::RegisterSpec for INPUTCTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [inputctrlb::R](R) reader structure"]
impl crate::Readable for INPUTCTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [inputctrlb::W](W) writer structure"]
impl crate::Writable for INPUTCTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INPUTCTRLB to value 0"]
impl crate::Resettable for INPUTCTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
