#[doc = "Register `XOSC32KCTRLA` reader"]
pub struct R(crate::R<XOSC32KCTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<XOSC32KCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<XOSC32KCTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<XOSC32KCTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `XOSC32KCTRLA` writer"]
pub struct W(crate::W<XOSC32KCTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<XOSC32KCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<XOSC32KCTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<XOSC32KCTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ENABLE` reader - Enable"]
pub struct ENABLE_R(crate::FieldReader<bool, bool>);
impl ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENABLE` writer - Enable"]
pub struct ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RUNSTDBY` reader - Run standby"]
pub struct RUNSTDBY_R(crate::FieldReader<bool, bool>);
impl RUNSTDBY_R {
    pub(crate) fn new(bits: bool) -> Self {
        RUNSTDBY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RUNSTDBY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RUNSTDBY` writer - Run standby"]
pub struct RUNSTDBY_W<'a> {
    w: &'a mut W,
}
impl<'a> RUNSTDBY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `SEL` reader - Select"]
pub struct SEL_R(crate::FieldReader<bool, bool>);
impl SEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SEL` writer - Select"]
pub struct SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Crystal startup time\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CSUT_A {
    #[doc = "0: 1K cycles"]
    _1K = 0,
    #[doc = "1: 16K cycles"]
    _16K = 1,
    #[doc = "2: 32K cycles"]
    _32K = 2,
    #[doc = "3: 64K cycles"]
    _64K = 3,
}
impl From<CSUT_A> for u8 {
    #[inline(always)]
    fn from(variant: CSUT_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CSUT` reader - Crystal startup time"]
pub struct CSUT_R(crate::FieldReader<u8, CSUT_A>);
impl CSUT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CSUT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CSUT_A {
        match self.bits {
            0 => CSUT_A::_1K,
            1 => CSUT_A::_16K,
            2 => CSUT_A::_32K,
            3 => CSUT_A::_64K,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `_1K`"]
    #[inline(always)]
    pub fn is_1k(&self) -> bool {
        **self == CSUT_A::_1K
    }
    #[doc = "Checks if the value of the field is `_16K`"]
    #[inline(always)]
    pub fn is_16k(&self) -> bool {
        **self == CSUT_A::_16K
    }
    #[doc = "Checks if the value of the field is `_32K`"]
    #[inline(always)]
    pub fn is_32k(&self) -> bool {
        **self == CSUT_A::_32K
    }
    #[doc = "Checks if the value of the field is `_64K`"]
    #[inline(always)]
    pub fn is_64k(&self) -> bool {
        **self == CSUT_A::_64K
    }
}
impl core::ops::Deref for CSUT_R {
    type Target = crate::FieldReader<u8, CSUT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSUT` writer - Crystal startup time"]
pub struct CSUT_W<'a> {
    w: &'a mut W,
}
impl<'a> CSUT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CSUT_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "1K cycles"]
    #[inline(always)]
    pub fn _1k(self) -> &'a mut W {
        self.variant(CSUT_A::_1K)
    }
    #[doc = "16K cycles"]
    #[inline(always)]
    pub fn _16k(self) -> &'a mut W {
        self.variant(CSUT_A::_16K)
    }
    #[doc = "32K cycles"]
    #[inline(always)]
    pub fn _32k(self) -> &'a mut W {
        self.variant(CSUT_A::_32K)
    }
    #[doc = "64K cycles"]
    #[inline(always)]
    pub fn _64k(self) -> &'a mut W {
        self.variant(CSUT_A::_64K)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable"]
    #[inline(always)]
    pub fn enable(&self) -> ENABLE_R {
        ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Run standby"]
    #[inline(always)]
    pub fn runstdby(&self) -> RUNSTDBY_R {
        RUNSTDBY_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Select"]
    #[inline(always)]
    pub fn sel(&self) -> SEL_R {
        SEL_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Crystal startup time"]
    #[inline(always)]
    pub fn csut(&self) -> CSUT_R {
        CSUT_R::new(((self.bits >> 4) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Enable"]
    #[inline(always)]
    pub fn enable(&mut self) -> ENABLE_W {
        ENABLE_W { w: self }
    }
    #[doc = "Bit 1 - Run standby"]
    #[inline(always)]
    pub fn runstdby(&mut self) -> RUNSTDBY_W {
        RUNSTDBY_W { w: self }
    }
    #[doc = "Bit 2 - Select"]
    #[inline(always)]
    pub fn sel(&mut self) -> SEL_W {
        SEL_W { w: self }
    }
    #[doc = "Bits 4:5 - Crystal startup time"]
    #[inline(always)]
    pub fn csut(&mut self) -> CSUT_W {
        CSUT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "XOSC32K Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [xosc32kctrla](index.html) module"]
pub struct XOSC32KCTRLA_SPEC;
impl crate::RegisterSpec for XOSC32KCTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [xosc32kctrla::R](R) reader structure"]
impl crate::Readable for XOSC32KCTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [xosc32kctrla::W](W) writer structure"]
impl crate::Writable for XOSC32KCTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets XOSC32KCTRLA to value 0"]
impl crate::Resettable for XOSC32KCTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
