#[doc = "Register `MCLKSTATUS` reader"]
pub struct R(crate::R<MCLKSTATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCLKSTATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCLKSTATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCLKSTATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `SOSC` reader - System Oscillator changing"]
pub struct SOSC_R(crate::FieldReader<bool, bool>);
impl SOSC_R {
    pub(crate) fn new(bits: bool) -> Self {
        SOSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOSC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OSC20MS` reader - 20MHz oscillator status"]
pub struct OSC20MS_R(crate::FieldReader<bool, bool>);
impl OSC20MS_R {
    pub(crate) fn new(bits: bool) -> Self {
        OSC20MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OSC20MS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OSC32KS` reader - 32KHz oscillator status"]
pub struct OSC32KS_R(crate::FieldReader<bool, bool>);
impl OSC32KS_R {
    pub(crate) fn new(bits: bool) -> Self {
        OSC32KS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OSC32KS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XOSC32KS` reader - 32.768 kHz Crystal Oscillator status"]
pub struct XOSC32KS_R(crate::FieldReader<bool, bool>);
impl XOSC32KS_R {
    pub(crate) fn new(bits: bool) -> Self {
        XOSC32KS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XOSC32KS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTS` reader - External Clock status"]
pub struct EXTS_R(crate::FieldReader<bool, bool>);
impl EXTS_R {
    pub(crate) fn new(bits: bool) -> Self {
        EXTS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - System Oscillator changing"]
    #[inline(always)]
    pub fn sosc(&self) -> SOSC_R {
        SOSC_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 4 - 20MHz oscillator status"]
    #[inline(always)]
    pub fn osc20ms(&self) -> OSC20MS_R {
        OSC20MS_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - 32KHz oscillator status"]
    #[inline(always)]
    pub fn osc32ks(&self) -> OSC32KS_R {
        OSC32KS_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - 32.768 kHz Crystal Oscillator status"]
    #[inline(always)]
    pub fn xosc32ks(&self) -> XOSC32KS_R {
        XOSC32KS_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - External Clock status"]
    #[inline(always)]
    pub fn exts(&self) -> EXTS_R {
        EXTS_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
#[doc = "MCLK Status\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mclkstatus](index.html) module"]
pub struct MCLKSTATUS_SPEC;
impl crate::RegisterSpec for MCLKSTATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mclkstatus::R](R) reader structure"]
impl crate::Readable for MCLKSTATUS_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets MCLKSTATUS to value 0"]
impl crate::Resettable for MCLKSTATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
