#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Timer/Counter1 Control Register C"]
    pub tccr1c: crate::Reg<tccr1c::TCCR1C_SPEC>,
    _reserved1: [u8; 0x01],
    #[doc = "0x02 - Timer/Counter1 Input Capture Register Bytes"]
    pub icr1: crate::Reg<icr1::ICR1_SPEC>,
    _reserved2: [u8; 0x02],
    #[doc = "0x06 - Timer/Counter1 Output Compare Register Bytes"]
    pub ocr1b: crate::Reg<ocr1b::OCR1B_SPEC>,
    #[doc = "0x08 - Timer/Counter1 Output Compare Register Bytes"]
    pub ocr1a: crate::Reg<ocr1a::OCR1A_SPEC>,
    #[doc = "0x0a - Timer/Counter1 Bytes"]
    pub tcnt1: crate::Reg<tcnt1::TCNT1_SPEC>,
    #[doc = "0x0c - Timer/Counter1 Control Register B"]
    pub tccr1b: crate::Reg<tccr1b::TCCR1B_SPEC>,
    #[doc = "0x0d - Timer/Counter1 Control Register A"]
    pub tccr1a: crate::Reg<tccr1a::TCCR1A_SPEC>,
    _reserved7: [u8; 0x08],
    #[doc = "0x16 - Timer/Counter Interrupt Flag register"]
    pub tifr: crate::Reg<tifr::TIFR_SPEC>,
    #[doc = "0x17 - Timer/Counter Interrupt Mask Register"]
    pub timsk: crate::Reg<timsk::TIMSK_SPEC>,
}
#[doc = "ICR1 register accessor: an alias for `Reg<ICR1_SPEC>`"]
pub type ICR1 = crate::Reg<icr1::ICR1_SPEC>;
#[doc = "Timer/Counter1 Input Capture Register Bytes"]
pub mod icr1;
#[doc = "OCR1A register accessor: an alias for `Reg<OCR1A_SPEC>`"]
pub type OCR1A = crate::Reg<ocr1a::OCR1A_SPEC>;
#[doc = "Timer/Counter1 Output Compare Register Bytes"]
pub mod ocr1a;
#[doc = "OCR1B register accessor: an alias for `Reg<OCR1B_SPEC>`"]
pub type OCR1B = crate::Reg<ocr1b::OCR1B_SPEC>;
#[doc = "Timer/Counter1 Output Compare Register Bytes"]
pub mod ocr1b;
#[doc = "TCCR1A register accessor: an alias for `Reg<TCCR1A_SPEC>`"]
pub type TCCR1A = crate::Reg<tccr1a::TCCR1A_SPEC>;
#[doc = "Timer/Counter1 Control Register A"]
pub mod tccr1a;
#[doc = "TCCR1B register accessor: an alias for `Reg<TCCR1B_SPEC>`"]
pub type TCCR1B = crate::Reg<tccr1b::TCCR1B_SPEC>;
#[doc = "Timer/Counter1 Control Register B"]
pub mod tccr1b;
#[doc = "TCCR1C register accessor: an alias for `Reg<TCCR1C_SPEC>`"]
pub type TCCR1C = crate::Reg<tccr1c::TCCR1C_SPEC>;
#[doc = "Timer/Counter1 Control Register C"]
pub mod tccr1c;
#[doc = "TCNT1 register accessor: an alias for `Reg<TCNT1_SPEC>`"]
pub type TCNT1 = crate::Reg<tcnt1::TCNT1_SPEC>;
#[doc = "Timer/Counter1 Bytes"]
pub mod tcnt1;
#[doc = "TIFR register accessor: an alias for `Reg<TIFR_SPEC>`"]
pub type TIFR = crate::Reg<tifr::TIFR_SPEC>;
#[doc = "Timer/Counter Interrupt Flag register"]
pub mod tifr;
#[doc = "TIMSK register accessor: an alias for `Reg<TIMSK_SPEC>`"]
pub type TIMSK = crate::Reg<timsk::TIMSK_SPEC>;
#[doc = "Timer/Counter Interrupt Mask Register"]
pub mod timsk;
