#[doc = "Register `PRR` reader"]
pub struct R(crate::R<PRR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PRR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PRR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PRR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PRR` writer"]
pub struct W(crate::W<PRR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PRR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PRR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PRR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PRUSART` reader - No Description."]
pub struct PRUSART_R(crate::FieldReader<bool, bool>);
impl PRUSART_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRUSART_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRUSART_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRUSART` writer - No Description."]
pub struct PRUSART_W<'a> {
    w: &'a mut W,
}
impl<'a> PRUSART_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PRUSI` reader - No Description."]
pub struct PRUSI_R(crate::FieldReader<bool, bool>);
impl PRUSI_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRUSI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRUSI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRUSI` writer - No Description."]
pub struct PRUSI_W<'a> {
    w: &'a mut W,
}
impl<'a> PRUSI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PRTIM` reader - No Description."]
pub struct PRTIM_R(crate::FieldReader<u8, u8>);
impl PRTIM_R {
    pub(crate) fn new(bits: u8) -> Self {
        PRTIM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM` writer - No Description."]
pub struct PRTIM_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn prusart(&self) -> PRUSART_R {
        PRUSART_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn prusi(&self) -> PRUSI_R {
        PRUSI_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:3 - No Description."]
    #[inline(always)]
    pub fn prtim(&self) -> PRTIM_R {
        PRTIM_R::new(((self.bits >> 2) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn prusart(&mut self) -> PRUSART_W {
        PRUSART_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn prusi(&mut self) -> PRUSI_W {
        PRUSI_W { w: self }
    }
    #[doc = "Bits 2:3 - No Description."]
    #[inline(always)]
    pub fn prtim(&mut self) -> PRTIM_W {
        PRTIM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Power reduction register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [prr](index.html) module"]
pub struct PRR_SPEC;
impl crate::RegisterSpec for PRR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [prr::R](R) reader structure"]
impl crate::Readable for PRR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [prr::W](W) writer structure"]
impl crate::Writable for PRR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PRR to value 0"]
impl crate::Resettable for PRR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
