#[doc = "Register `BODCR` reader"]
pub struct R(crate::R<BODCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<BODCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<BODCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<BODCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `BODCR` writer"]
pub struct W(crate::W<BODCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<BODCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<BODCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<BODCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BPDSE` reader - No Description."]
pub struct BPDSE_R(crate::FieldReader<bool, bool>);
impl BPDSE_R {
    pub(crate) fn new(bits: bool) -> Self {
        BPDSE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BPDSE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BPDSE` writer - No Description."]
pub struct BPDSE_W<'a> {
    w: &'a mut W,
}
impl<'a> BPDSE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `BPDS` reader - No Description."]
pub struct BPDS_R(crate::FieldReader<bool, bool>);
impl BPDS_R {
    pub(crate) fn new(bits: bool) -> Self {
        BPDS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BPDS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BPDS` writer - No Description."]
pub struct BPDS_W<'a> {
    w: &'a mut W,
}
impl<'a> BPDS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn bpdse(&self) -> BPDSE_R {
        BPDSE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn bpds(&self) -> BPDS_R {
        BPDS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn bpdse(&mut self) -> BPDSE_W {
        BPDSE_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn bpds(&mut self) -> BPDS_W {
        BPDS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "BOD control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [bodcr](index.html) module"]
pub struct BODCR_SPEC;
impl crate::RegisterSpec for BODCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [bodcr::R](R) reader structure"]
impl crate::Readable for BODCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [bodcr::W](W) writer structure"]
impl crate::Writable for BODCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets BODCR to value 0"]
impl crate::Resettable for BODCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
