#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Power reduction register"]
    pub prr: crate::Reg<prr::PRR_SPEC>,
    #[doc = "0x01 - BOD control register"]
    pub bodcr: crate::Reg<bodcr::BODCR_SPEC>,
    _reserved2: [u8; 0x0b],
    #[doc = "0x0d - General Purpose I/O Register 0"]
    pub gpior0: crate::Reg<gpior0::GPIOR0_SPEC>,
    #[doc = "0x0e - General Purpose I/O Register 1"]
    pub gpior1: crate::Reg<gpior1::GPIOR1_SPEC>,
    #[doc = "0x0f - General Purpose I/O Register 2"]
    pub gpior2: crate::Reg<gpior2::GPIOR2_SPEC>,
    _reserved5: [u8; 0x0d],
    #[doc = "0x1d - General Timer Counter Control Register"]
    pub gtccr: crate::Reg<gtccr::GTCCR_SPEC>,
    _reserved6: [u8; 0x02],
    #[doc = "0x20 - Clock Prescale Register"]
    pub clkpr: crate::Reg<clkpr::CLKPR_SPEC>,
    _reserved7: [u8; 0x0a],
    #[doc = "0x2b - Oscillator Calibration Register"]
    pub osccal: crate::Reg<osccal::OSCCAL_SPEC>,
    _reserved8: [u8; 0x02],
    #[doc = "0x2e - MCU Status register"]
    pub mcusr: crate::Reg<mcusr::MCUSR_SPEC>,
    #[doc = "0x2f - MCU Control Register"]
    pub mcucr: crate::Reg<mcucr::MCUCR_SPEC>,
    _reserved10: [u8; 0x01],
    #[doc = "0x31 - Store Program Memory Control and Status register"]
    pub spmcsr: crate::Reg<spmcsr::SPMCSR_SPEC>,
    _reserved11: [u8; 0x05],
    #[doc = "0x37 - Stack Pointer Low Byte"]
    pub spl: crate::Reg<spl::SPL_SPEC>,
}
#[doc = "BODCR register accessor: an alias for `Reg<BODCR_SPEC>`"]
pub type BODCR = crate::Reg<bodcr::BODCR_SPEC>;
#[doc = "BOD control register"]
pub mod bodcr;
#[doc = "CLKPR register accessor: an alias for `Reg<CLKPR_SPEC>`"]
pub type CLKPR = crate::Reg<clkpr::CLKPR_SPEC>;
#[doc = "Clock Prescale Register"]
pub mod clkpr;
#[doc = "GPIOR0 register accessor: an alias for `Reg<GPIOR0_SPEC>`"]
pub type GPIOR0 = crate::Reg<gpior0::GPIOR0_SPEC>;
#[doc = "General Purpose I/O Register 0"]
pub mod gpior0;
#[doc = "GPIOR1 register accessor: an alias for `Reg<GPIOR1_SPEC>`"]
pub type GPIOR1 = crate::Reg<gpior1::GPIOR1_SPEC>;
#[doc = "General Purpose I/O Register 1"]
pub mod gpior1;
#[doc = "GPIOR2 register accessor: an alias for `Reg<GPIOR2_SPEC>`"]
pub type GPIOR2 = crate::Reg<gpior2::GPIOR2_SPEC>;
#[doc = "General Purpose I/O Register 2"]
pub mod gpior2;
#[doc = "GTCCR register accessor: an alias for `Reg<GTCCR_SPEC>`"]
pub type GTCCR = crate::Reg<gtccr::GTCCR_SPEC>;
#[doc = "General Timer Counter Control Register"]
pub mod gtccr;
#[doc = "MCUCR register accessor: an alias for `Reg<MCUCR_SPEC>`"]
pub type MCUCR = crate::Reg<mcucr::MCUCR_SPEC>;
#[doc = "MCU Control Register"]
pub mod mcucr;
#[doc = "MCUSR register accessor: an alias for `Reg<MCUSR_SPEC>`"]
pub type MCUSR = crate::Reg<mcusr::MCUSR_SPEC>;
#[doc = "MCU Status register"]
pub mod mcusr;
#[doc = "OSCCAL register accessor: an alias for `Reg<OSCCAL_SPEC>`"]
pub type OSCCAL = crate::Reg<osccal::OSCCAL_SPEC>;
#[doc = "Oscillator Calibration Register"]
pub mod osccal;
#[doc = "PRR register accessor: an alias for `Reg<PRR_SPEC>`"]
pub type PRR = crate::Reg<prr::PRR_SPEC>;
#[doc = "Power reduction register"]
pub mod prr;
#[doc = "SPL register accessor: an alias for `Reg<SPL_SPEC>`"]
pub type SPL = crate::Reg<spl::SPL_SPEC>;
#[doc = "Stack Pointer Low Byte"]
pub mod spl;
#[doc = "SPMCSR register accessor: an alias for `Reg<SPMCSR_SPEC>`"]
pub type SPMCSR = crate::Reg<spmcsr::SPMCSR_SPEC>;
#[doc = "Store Program Memory Control and Status register"]
pub mod spmcsr;
