#[doc = "Register `STATUS` reader"]
pub struct R(crate::R<STATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `STATUS` writer"]
pub struct W(crate::W<STATUS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<STATUS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<STATUS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WFB` reader - Wait For Break"]
pub struct WFB_R(crate::FieldReader<bool, bool>);
impl WFB_R {
    pub(crate) fn new(bits: bool) -> Self {
        WFB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WFB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WFB` writer - Wait For Break"]
pub struct WFB_W<'a> {
    w: &'a mut W,
}
impl<'a> WFB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `BDF` reader - Break Detected Flag"]
pub struct BDF_R(crate::FieldReader<bool, bool>);
impl BDF_R {
    pub(crate) fn new(bits: bool) -> Self {
        BDF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BDF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BDF` writer - Break Detected Flag"]
pub struct BDF_W<'a> {
    w: &'a mut W,
}
impl<'a> BDF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `ISFIF` reader - Inconsistent Sync Field Interrupt Flag"]
pub struct ISFIF_R(crate::FieldReader<bool, bool>);
impl ISFIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        ISFIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISFIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISFIF` writer - Inconsistent Sync Field Interrupt Flag"]
pub struct ISFIF_W<'a> {
    w: &'a mut W,
}
impl<'a> ISFIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXSIF` reader - Receive Start Interrupt"]
pub struct RXSIF_R(crate::FieldReader<bool, bool>);
impl RXSIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DREIF` reader - Data Register Empty Flag"]
pub struct DREIF_R(crate::FieldReader<bool, bool>);
impl DREIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        DREIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DREIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIF` reader - Transmit Interrupt Flag"]
pub struct TXCIF_R(crate::FieldReader<bool, bool>);
impl TXCIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIF` writer - Transmit Interrupt Flag"]
pub struct TXCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIF` reader - Receive Complete Interrupt Flag"]
pub struct RXCIF_R(crate::FieldReader<bool, bool>);
impl RXCIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - Wait For Break"]
    #[inline(always)]
    pub fn wfb(&self) -> WFB_R {
        WFB_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Break Detected Flag"]
    #[inline(always)]
    pub fn bdf(&self) -> BDF_R {
        BDF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Inconsistent Sync Field Interrupt Flag"]
    #[inline(always)]
    pub fn isfif(&self) -> ISFIF_R {
        ISFIF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receive Start Interrupt"]
    #[inline(always)]
    pub fn rxsif(&self) -> RXSIF_R {
        RXSIF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Data Register Empty Flag"]
    #[inline(always)]
    pub fn dreif(&self) -> DREIF_R {
        DREIF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Transmit Interrupt Flag"]
    #[inline(always)]
    pub fn txcif(&self) -> TXCIF_R {
        TXCIF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Receive Complete Interrupt Flag"]
    #[inline(always)]
    pub fn rxcif(&self) -> RXCIF_R {
        RXCIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Wait For Break"]
    #[inline(always)]
    pub fn wfb(&mut self) -> WFB_W {
        WFB_W { w: self }
    }
    #[doc = "Bit 1 - Break Detected Flag"]
    #[inline(always)]
    pub fn bdf(&mut self) -> BDF_W {
        BDF_W { w: self }
    }
    #[doc = "Bit 3 - Inconsistent Sync Field Interrupt Flag"]
    #[inline(always)]
    pub fn isfif(&mut self) -> ISFIF_W {
        ISFIF_W { w: self }
    }
    #[doc = "Bit 6 - Transmit Interrupt Flag"]
    #[inline(always)]
    pub fn txcif(&mut self) -> TXCIF_W {
        TXCIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Status\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [status](index.html) module"]
pub struct STATUS_SPEC;
impl crate::RegisterSpec for STATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [status::R](R) reader structure"]
impl crate::Readable for STATUS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [status::W](W) writer structure"]
impl crate::Writable for STATUS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets STATUS to value 0"]
impl crate::Resettable for STATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
