#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Timer/Counter1 Interrupt Flag register"]
    pub tifr1: crate::Reg<tifr1::TIFR1_SPEC>,
    _reserved1: [u8; 0x38],
    #[doc = "0x39 - Timer/Counter1 Interrupt Mask Register"]
    pub timsk1: crate::Reg<timsk1::TIMSK1_SPEC>,
    _reserved2: [u8; 0x10],
    #[doc = "0x4a - Timer/Counter1 Control Register A"]
    pub tccr1a: crate::Reg<tccr1a::TCCR1A_SPEC>,
    #[doc = "0x4b - Timer/Counter1 Control Register B"]
    pub tccr1b: crate::Reg<tccr1b::TCCR1B_SPEC>,
    #[doc = "0x4c - Timer/Counter1 Control Register C"]
    pub tccr1c: crate::Reg<tccr1c::TCCR1C_SPEC>,
    #[doc = "0x4d - Timer/Counter1 Control Register D"]
    pub tccr1d: crate::Reg<tccr1d::TCCR1D_SPEC>,
    #[doc = "0x4e - Timer/Counter1 Bytes"]
    pub tcnt1: crate::Reg<tcnt1::TCNT1_SPEC>,
    #[doc = "0x50 - Timer/Counter1 Input Capture Register Bytes"]
    pub icr1: crate::Reg<icr1::ICR1_SPEC>,
    #[doc = "0x52 - Timer/Counter1 Output Compare Register A Bytes"]
    pub ocr1a: crate::Reg<ocr1a::OCR1A_SPEC>,
    #[doc = "0x54 - Timer/Counter1 Output Compare Register B Bytes"]
    pub ocr1b: crate::Reg<ocr1b::OCR1B_SPEC>,
}
#[doc = "ICR1 register accessor: an alias for `Reg<ICR1_SPEC>`"]
pub type ICR1 = crate::Reg<icr1::ICR1_SPEC>;
#[doc = "Timer/Counter1 Input Capture Register Bytes"]
pub mod icr1;
#[doc = "OCR1A register accessor: an alias for `Reg<OCR1A_SPEC>`"]
pub type OCR1A = crate::Reg<ocr1a::OCR1A_SPEC>;
#[doc = "Timer/Counter1 Output Compare Register A Bytes"]
pub mod ocr1a;
#[doc = "OCR1B register accessor: an alias for `Reg<OCR1B_SPEC>`"]
pub type OCR1B = crate::Reg<ocr1b::OCR1B_SPEC>;
#[doc = "Timer/Counter1 Output Compare Register B Bytes"]
pub mod ocr1b;
#[doc = "TCCR1A register accessor: an alias for `Reg<TCCR1A_SPEC>`"]
pub type TCCR1A = crate::Reg<tccr1a::TCCR1A_SPEC>;
#[doc = "Timer/Counter1 Control Register A"]
pub mod tccr1a;
#[doc = "TCCR1B register accessor: an alias for `Reg<TCCR1B_SPEC>`"]
pub type TCCR1B = crate::Reg<tccr1b::TCCR1B_SPEC>;
#[doc = "Timer/Counter1 Control Register B"]
pub mod tccr1b;
#[doc = "TCCR1C register accessor: an alias for `Reg<TCCR1C_SPEC>`"]
pub type TCCR1C = crate::Reg<tccr1c::TCCR1C_SPEC>;
#[doc = "Timer/Counter1 Control Register C"]
pub mod tccr1c;
#[doc = "TCCR1D register accessor: an alias for `Reg<TCCR1D_SPEC>`"]
pub type TCCR1D = crate::Reg<tccr1d::TCCR1D_SPEC>;
#[doc = "Timer/Counter1 Control Register D"]
pub mod tccr1d;
#[doc = "TCNT1 register accessor: an alias for `Reg<TCNT1_SPEC>`"]
pub type TCNT1 = crate::Reg<tcnt1::TCNT1_SPEC>;
#[doc = "Timer/Counter1 Bytes"]
pub mod tcnt1;
#[doc = "TIFR1 register accessor: an alias for `Reg<TIFR1_SPEC>`"]
pub type TIFR1 = crate::Reg<tifr1::TIFR1_SPEC>;
#[doc = "Timer/Counter1 Interrupt Flag register"]
pub mod tifr1;
#[doc = "TIMSK1 register accessor: an alias for `Reg<TIMSK1_SPEC>`"]
pub type TIMSK1 = crate::Reg<timsk1::TIMSK1_SPEC>;
#[doc = "Timer/Counter1 Interrupt Mask Register"]
pub mod timsk1;
