#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Timer/Counter0 Interrupt Flag Register"]
    pub tifr0: crate::Reg<tifr0::TIFR0_SPEC>,
    _reserved1: [u8; 0x0d],
    #[doc = "0x0e - General Timer Counter Control register"]
    pub gtccr: crate::Reg<gtccr::GTCCR_SPEC>,
    _reserved2: [u8; 0x01],
    #[doc = "0x10 - Timer/Counter0 Control Register A"]
    pub tccr0a: crate::Reg<tccr0a::TCCR0A_SPEC>,
    #[doc = "0x11 - Timer/Counter0 Control Register B"]
    pub tccr0b: crate::Reg<tccr0b::TCCR0B_SPEC>,
    #[doc = "0x12 - Timer/Counter0"]
    pub tcnt0: crate::Reg<tcnt0::TCNT0_SPEC>,
    #[doc = "0x13 - Timer/Counter0 Output Compare Register A"]
    pub ocr0a: crate::Reg<ocr0a::OCR0A_SPEC>,
    _reserved6: [u8; 0x25],
    #[doc = "0x39 - Timer/Counter0 Interrupt Mask register"]
    pub timsk0: crate::Reg<timsk0::TIMSK0_SPEC>,
    _reserved7: [u8; 0x47],
    #[doc = "0x81 - Asynchronous Status Register"]
    pub assr: crate::Reg<assr::ASSR_SPEC>,
}
#[doc = "ASSR register accessor: an alias for `Reg<ASSR_SPEC>`"]
pub type ASSR = crate::Reg<assr::ASSR_SPEC>;
#[doc = "Asynchronous Status Register"]
pub mod assr;
#[doc = "GTCCR register accessor: an alias for `Reg<GTCCR_SPEC>`"]
pub type GTCCR = crate::Reg<gtccr::GTCCR_SPEC>;
#[doc = "General Timer Counter Control register"]
pub mod gtccr;
#[doc = "OCR0A register accessor: an alias for `Reg<OCR0A_SPEC>`"]
pub type OCR0A = crate::Reg<ocr0a::OCR0A_SPEC>;
#[doc = "Timer/Counter0 Output Compare Register A"]
pub mod ocr0a;
#[doc = "TCCR0A register accessor: an alias for `Reg<TCCR0A_SPEC>`"]
pub type TCCR0A = crate::Reg<tccr0a::TCCR0A_SPEC>;
#[doc = "Timer/Counter0 Control Register A"]
pub mod tccr0a;
#[doc = "TCCR0B register accessor: an alias for `Reg<TCCR0B_SPEC>`"]
pub type TCCR0B = crate::Reg<tccr0b::TCCR0B_SPEC>;
#[doc = "Timer/Counter0 Control Register B"]
pub mod tccr0b;
#[doc = "TCNT0 register accessor: an alias for `Reg<TCNT0_SPEC>`"]
pub type TCNT0 = crate::Reg<tcnt0::TCNT0_SPEC>;
#[doc = "Timer/Counter0"]
pub mod tcnt0;
#[doc = "TIFR0 register accessor: an alias for `Reg<TIFR0_SPEC>`"]
pub type TIFR0 = crate::Reg<tifr0::TIFR0_SPEC>;
#[doc = "Timer/Counter0 Interrupt Flag Register"]
pub mod tifr0;
#[doc = "TIMSK0 register accessor: an alias for `Reg<TIMSK0_SPEC>`"]
pub type TIMSK0 = crate::Reg<timsk0::TIMSK0_SPEC>;
#[doc = "Timer/Counter0 Interrupt Mask register"]
pub mod timsk0;
