#[doc = "Register `LINSIR` reader"]
pub struct R(crate::R<LINSIR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINSIR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINSIR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINSIR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINSIR` writer"]
pub struct W(crate::W<LINSIR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINSIR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINSIR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINSIR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LRXOK` reader - Receive Performed Interrupt"]
pub struct LRXOK_R(crate::FieldReader<bool, bool>);
impl LRXOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LRXOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LRXOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LRXOK` writer - Receive Performed Interrupt"]
pub struct LRXOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LRXOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `LTXOK` reader - Transmit Performed Interrupt"]
pub struct LTXOK_R(crate::FieldReader<bool, bool>);
impl LTXOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LTXOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LTXOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LTXOK` writer - Transmit Performed Interrupt"]
pub struct LTXOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LTXOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LIDOK` reader - Identifier Interrupt"]
pub struct LIDOK_R(crate::FieldReader<bool, bool>);
impl LIDOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LIDOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LIDOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LIDOK` writer - Identifier Interrupt"]
pub struct LIDOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LIDOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LERR` reader - Error Interrupt"]
pub struct LERR_R(crate::FieldReader<bool, bool>);
impl LERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LERR` writer - Error Interrupt"]
pub struct LERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `LBUSY` reader - Busy Signal"]
pub struct LBUSY_R(crate::FieldReader<bool, bool>);
impl LBUSY_R {
    pub(crate) fn new(bits: bool) -> Self {
        LBUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LBUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LBUSY` writer - Busy Signal"]
pub struct LBUSY_W<'a> {
    w: &'a mut W,
}
impl<'a> LBUSY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `LIDST` reader - Identifier Status bits"]
pub struct LIDST_R(crate::FieldReader<u8, u8>);
impl LIDST_R {
    pub(crate) fn new(bits: u8) -> Self {
        LIDST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LIDST_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LIDST` writer - Identifier Status bits"]
pub struct LIDST_W<'a> {
    w: &'a mut W,
}
impl<'a> LIDST_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Receive Performed Interrupt"]
    #[inline(always)]
    pub fn lrxok(&self) -> LRXOK_R {
        LRXOK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Transmit Performed Interrupt"]
    #[inline(always)]
    pub fn ltxok(&self) -> LTXOK_R {
        LTXOK_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Identifier Interrupt"]
    #[inline(always)]
    pub fn lidok(&self) -> LIDOK_R {
        LIDOK_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Error Interrupt"]
    #[inline(always)]
    pub fn lerr(&self) -> LERR_R {
        LERR_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Busy Signal"]
    #[inline(always)]
    pub fn lbusy(&self) -> LBUSY_R {
        LBUSY_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bits 5:7 - Identifier Status bits"]
    #[inline(always)]
    pub fn lidst(&self) -> LIDST_R {
        LIDST_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Receive Performed Interrupt"]
    #[inline(always)]
    pub fn lrxok(&mut self) -> LRXOK_W {
        LRXOK_W { w: self }
    }
    #[doc = "Bit 1 - Transmit Performed Interrupt"]
    #[inline(always)]
    pub fn ltxok(&mut self) -> LTXOK_W {
        LTXOK_W { w: self }
    }
    #[doc = "Bit 2 - Identifier Interrupt"]
    #[inline(always)]
    pub fn lidok(&mut self) -> LIDOK_W {
        LIDOK_W { w: self }
    }
    #[doc = "Bit 3 - Error Interrupt"]
    #[inline(always)]
    pub fn lerr(&mut self) -> LERR_W {
        LERR_W { w: self }
    }
    #[doc = "Bit 4 - Busy Signal"]
    #[inline(always)]
    pub fn lbusy(&mut self) -> LBUSY_W {
        LBUSY_W { w: self }
    }
    #[doc = "Bits 5:7 - Identifier Status bits"]
    #[inline(always)]
    pub fn lidst(&mut self) -> LIDST_W {
        LIDST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Status and Interrupt Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [linsir](index.html) module"]
pub struct LINSIR_SPEC;
impl crate::RegisterSpec for LINSIR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [linsir::R](R) reader structure"]
impl crate::Readable for LINSIR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [linsir::W](W) writer structure"]
impl crate::Writable for LINSIR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINSIR to value 0"]
impl crate::Resettable for LINSIR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
