#[doc = "Register `LINSEL` reader"]
pub struct R(crate::R<LINSEL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINSEL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINSEL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINSEL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINSEL` writer"]
pub struct W(crate::W<LINSEL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINSEL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINSEL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINSEL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LINDX` reader - FIFO LIN Data Buffer Index bits"]
pub struct LINDX_R(crate::FieldReader<u8, u8>);
impl LINDX_R {
    pub(crate) fn new(bits: u8) -> Self {
        LINDX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LINDX_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LINDX` writer - FIFO LIN Data Buffer Index bits"]
pub struct LINDX_W<'a> {
    w: &'a mut W,
}
impl<'a> LINDX_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `LAINC` reader - Auto Increment of Data Buffer Index (Active Low)"]
pub struct LAINC_R(crate::FieldReader<bool, bool>);
impl LAINC_R {
    pub(crate) fn new(bits: bool) -> Self {
        LAINC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LAINC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LAINC` writer - Auto Increment of Data Buffer Index (Active Low)"]
pub struct LAINC_W<'a> {
    w: &'a mut W,
}
impl<'a> LAINC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - FIFO LIN Data Buffer Index bits"]
    #[inline(always)]
    pub fn lindx(&self) -> LINDX_R {
        LINDX_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Auto Increment of Data Buffer Index (Active Low)"]
    #[inline(always)]
    pub fn lainc(&self) -> LAINC_R {
        LAINC_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - FIFO LIN Data Buffer Index bits"]
    #[inline(always)]
    pub fn lindx(&mut self) -> LINDX_W {
        LINDX_W { w: self }
    }
    #[doc = "Bit 3 - Auto Increment of Data Buffer Index (Active Low)"]
    #[inline(always)]
    pub fn lainc(&mut self) -> LAINC_W {
        LAINC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Data Buffer Selection Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [linsel](index.html) module"]
pub struct LINSEL_SPEC;
impl crate::RegisterSpec for LINSEL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [linsel::R](R) reader structure"]
impl crate::Readable for LINSEL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [linsel::W](W) writer structure"]
impl crate::Writable for LINSEL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINSEL to value 0"]
impl crate::Resettable for LINSEL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
