#[doc = "Register `LINERR` reader"]
pub struct R(crate::R<LINERR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINERR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINERR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINERR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINERR` writer"]
pub struct W(crate::W<LINERR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINERR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINERR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINERR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LBERR` reader - Bit Error Flag"]
pub struct LBERR_R(crate::FieldReader<bool, bool>);
impl LBERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LBERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LBERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LBERR` writer - Bit Error Flag"]
pub struct LBERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LBERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `LCERR` reader - Checksum Error Flag"]
pub struct LCERR_R(crate::FieldReader<bool, bool>);
impl LCERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LCERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LCERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LCERR` writer - Checksum Error Flag"]
pub struct LCERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LCERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LPERR` reader - Parity Error Flag"]
pub struct LPERR_R(crate::FieldReader<bool, bool>);
impl LPERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LPERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPERR` writer - Parity Error Flag"]
pub struct LPERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LPERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LSERR` reader - Synchronization Error Flag"]
pub struct LSERR_R(crate::FieldReader<bool, bool>);
impl LSERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LSERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LSERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LSERR` writer - Synchronization Error Flag"]
pub struct LSERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LSERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `LFERR` reader - Framing Error Flag"]
pub struct LFERR_R(crate::FieldReader<bool, bool>);
impl LFERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LFERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LFERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LFERR` writer - Framing Error Flag"]
pub struct LFERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LFERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `LOVERR` reader - Overrun Error Flag"]
pub struct LOVERR_R(crate::FieldReader<bool, bool>);
impl LOVERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LOVERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LOVERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LOVERR` writer - Overrun Error Flag"]
pub struct LOVERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LOVERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `LTOERR` reader - Frame Time Out Error Flag"]
pub struct LTOERR_R(crate::FieldReader<bool, bool>);
impl LTOERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LTOERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LTOERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LTOERR` writer - Frame Time Out Error Flag"]
pub struct LTOERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LTOERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `LABORT` reader - Abort Flag"]
pub struct LABORT_R(crate::FieldReader<bool, bool>);
impl LABORT_R {
    pub(crate) fn new(bits: bool) -> Self {
        LABORT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LABORT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LABORT` writer - Abort Flag"]
pub struct LABORT_W<'a> {
    w: &'a mut W,
}
impl<'a> LABORT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Bit Error Flag"]
    #[inline(always)]
    pub fn lberr(&self) -> LBERR_R {
        LBERR_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Checksum Error Flag"]
    #[inline(always)]
    pub fn lcerr(&self) -> LCERR_R {
        LCERR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Parity Error Flag"]
    #[inline(always)]
    pub fn lperr(&self) -> LPERR_R {
        LPERR_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Synchronization Error Flag"]
    #[inline(always)]
    pub fn lserr(&self) -> LSERR_R {
        LSERR_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Framing Error Flag"]
    #[inline(always)]
    pub fn lferr(&self) -> LFERR_R {
        LFERR_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Overrun Error Flag"]
    #[inline(always)]
    pub fn loverr(&self) -> LOVERR_R {
        LOVERR_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Frame Time Out Error Flag"]
    #[inline(always)]
    pub fn ltoerr(&self) -> LTOERR_R {
        LTOERR_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Abort Flag"]
    #[inline(always)]
    pub fn labort(&self) -> LABORT_R {
        LABORT_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Bit Error Flag"]
    #[inline(always)]
    pub fn lberr(&mut self) -> LBERR_W {
        LBERR_W { w: self }
    }
    #[doc = "Bit 1 - Checksum Error Flag"]
    #[inline(always)]
    pub fn lcerr(&mut self) -> LCERR_W {
        LCERR_W { w: self }
    }
    #[doc = "Bit 2 - Parity Error Flag"]
    #[inline(always)]
    pub fn lperr(&mut self) -> LPERR_W {
        LPERR_W { w: self }
    }
    #[doc = "Bit 3 - Synchronization Error Flag"]
    #[inline(always)]
    pub fn lserr(&mut self) -> LSERR_W {
        LSERR_W { w: self }
    }
    #[doc = "Bit 4 - Framing Error Flag"]
    #[inline(always)]
    pub fn lferr(&mut self) -> LFERR_W {
        LFERR_W { w: self }
    }
    #[doc = "Bit 5 - Overrun Error Flag"]
    #[inline(always)]
    pub fn loverr(&mut self) -> LOVERR_W {
        LOVERR_W { w: self }
    }
    #[doc = "Bit 6 - Frame Time Out Error Flag"]
    #[inline(always)]
    pub fn ltoerr(&mut self) -> LTOERR_W {
        LTOERR_W { w: self }
    }
    #[doc = "Bit 7 - Abort Flag"]
    #[inline(always)]
    pub fn labort(&mut self) -> LABORT_W {
        LABORT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Error Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [linerr](index.html) module"]
pub struct LINERR_SPEC;
impl crate::RegisterSpec for LINERR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [linerr::R](R) reader structure"]
impl crate::Readable for LINERR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [linerr::W](W) writer structure"]
impl crate::Writable for LINERR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINERR to value 0"]
impl crate::Resettable for LINERR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
