#[doc = "Register `AMISCR` reader"]
pub struct R(crate::R<AMISCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AMISCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AMISCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AMISCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AMISCR` writer"]
pub struct W(crate::W<AMISCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AMISCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AMISCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AMISCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ISRCEN` reader - Current Source Enable"]
pub struct ISRCEN_R(crate::FieldReader<bool, bool>);
impl ISRCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ISRCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISRCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISRCEN` writer - Current Source Enable"]
pub struct ISRCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ISRCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Current Source Enable"]
    #[inline(always)]
    pub fn isrcen(&self) -> ISRCEN_R {
        ISRCEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Current Source Enable"]
    #[inline(always)]
    pub fn isrcen(&mut self) -> ISRCEN_W {
        ISRCEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Miscellaneous Control Register (Shared with AD_CONVERTER IO_MODULE)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [amiscr](index.html) module"]
pub struct AMISCR_SPEC;
impl crate::RegisterSpec for AMISCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [amiscr::R](R) reader structure"]
impl crate::Readable for AMISCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [amiscr::W](W) writer structure"]
impl crate::Writable for AMISCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AMISCR to value 0"]
impl crate::Resettable for AMISCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
