#[doc = "Register `CLKSELR` reader"]
pub struct R(crate::R<CLKSELR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CLKSELR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CLKSELR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CLKSELR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CLKSELR` writer"]
pub struct W(crate::W<CLKSELR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CLKSELR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CLKSELR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CLKSELR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CSEL` reader - Clock Source Select bit 3 - CKSEL3 fuse substitution"]
pub struct CSEL_R(crate::FieldReader<u8, u8>);
impl CSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CSEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSEL` writer - Clock Source Select bit 3 - CKSEL3 fuse substitution"]
pub struct CSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CSEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `CSUT` reader - Clock Start-up Time bit 1 - SUT1 fuse substitution"]
pub struct CSUT_R(crate::FieldReader<u8, u8>);
impl CSUT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CSUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CSUT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSUT` writer - Clock Start-up Time bit 1 - SUT1 fuse substitution"]
pub struct CSUT_W<'a> {
    w: &'a mut W,
}
impl<'a> CSUT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `COUT` reader - Clock Out - CKOUT fuse substitution"]
pub struct COUT_R(crate::FieldReader<bool, bool>);
impl COUT_R {
    pub(crate) fn new(bits: bool) -> Self {
        COUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COUT` writer - Clock Out - CKOUT fuse substitution"]
pub struct COUT_W<'a> {
    w: &'a mut W,
}
impl<'a> COUT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Clock Source Select bit 3 - CKSEL3 fuse substitution"]
    #[inline(always)]
    pub fn csel(&self) -> CSEL_R {
        CSEL_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:5 - Clock Start-up Time bit 1 - SUT1 fuse substitution"]
    #[inline(always)]
    pub fn csut(&self) -> CSUT_R {
        CSUT_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Clock Out - CKOUT fuse substitution"]
    #[inline(always)]
    pub fn cout(&self) -> COUT_R {
        COUT_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Clock Source Select bit 3 - CKSEL3 fuse substitution"]
    #[inline(always)]
    pub fn csel(&mut self) -> CSEL_W {
        CSEL_W { w: self }
    }
    #[doc = "Bits 4:5 - Clock Start-up Time bit 1 - SUT1 fuse substitution"]
    #[inline(always)]
    pub fn csut(&mut self) -> CSUT_W {
        CSUT_W { w: self }
    }
    #[doc = "Bit 6 - Clock Out - CKOUT fuse substitution"]
    #[inline(always)]
    pub fn cout(&mut self) -> COUT_W {
        COUT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock Selection Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [clkselr](index.html) module"]
pub struct CLKSELR_SPEC;
impl crate::RegisterSpec for CLKSELR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [clkselr::R](R) reader structure"]
impl crate::Readable for CLKSELR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [clkselr::W](W) writer structure"]
impl crate::Writable for CLKSELR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CLKSELR to value 0"]
impl crate::Resettable for CLKSELR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
