#[doc = "Register `WDTCKD` reader"]
pub struct R(crate::R<WDTCKD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<WDTCKD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<WDTCKD_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<WDTCKD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `WDTCKD` writer"]
pub struct W(crate::W<WDTCKD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<WDTCKD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<WDTCKD_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<WDTCKD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WCLKD` reader - Watchdog Timer Clock Dividers"]
pub struct WCLKD_R(crate::FieldReader<u8, u8>);
impl WCLKD_R {
    pub(crate) fn new(bits: u8) -> Self {
        WCLKD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WCLKD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WCLKD` writer - Watchdog Timer Clock Dividers"]
pub struct WCLKD_W<'a> {
    w: &'a mut W,
}
impl<'a> WCLKD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `WDEWIE` reader - Watchdog Early Warning Interrupt Enable"]
pub struct WDEWIE_R(crate::FieldReader<bool, bool>);
impl WDEWIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDEWIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDEWIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDEWIE` writer - Watchdog Early Warning Interrupt Enable"]
pub struct WDEWIE_W<'a> {
    w: &'a mut W,
}
impl<'a> WDEWIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `WDEWIF` reader - Watchdog Early Warning Interrupt Flag"]
pub struct WDEWIF_R(crate::FieldReader<bool, bool>);
impl WDEWIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDEWIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDEWIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDEWIF` writer - Watchdog Early Warning Interrupt Flag"]
pub struct WDEWIF_W<'a> {
    w: &'a mut W,
}
impl<'a> WDEWIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Watchdog Timer Clock Dividers"]
    #[inline(always)]
    pub fn wclkd(&self) -> WCLKD_R {
        WCLKD_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Watchdog Early Warning Interrupt Enable"]
    #[inline(always)]
    pub fn wdewie(&self) -> WDEWIE_R {
        WDEWIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Watchdog Early Warning Interrupt Flag"]
    #[inline(always)]
    pub fn wdewif(&self) -> WDEWIF_R {
        WDEWIF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Watchdog Timer Clock Dividers"]
    #[inline(always)]
    pub fn wclkd(&mut self) -> WCLKD_W {
        WCLKD_W { w: self }
    }
    #[doc = "Bit 2 - Watchdog Early Warning Interrupt Enable"]
    #[inline(always)]
    pub fn wdewie(&mut self) -> WDEWIE_W {
        WDEWIE_W { w: self }
    }
    #[doc = "Bit 3 - Watchdog Early Warning Interrupt Flag"]
    #[inline(always)]
    pub fn wdewif(&mut self) -> WDEWIF_W {
        WDEWIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Watchdog Timer Clock Divider\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [wdtckd](index.html) module"]
pub struct WDTCKD_SPEC;
impl crate::RegisterSpec for WDTCKD_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [wdtckd::R](R) reader structure"]
impl crate::Readable for WDTCKD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [wdtckd::W](W) writer structure"]
impl crate::Writable for WDTCKD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets WDTCKD to value 0"]
impl crate::Resettable for WDTCKD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
