#[doc = "Register `UESTA0X` reader"]
pub struct R(crate::R<UESTA0X_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UESTA0X_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UESTA0X_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UESTA0X_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UESTA0X` writer"]
pub struct W(crate::W<UESTA0X_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UESTA0X_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UESTA0X_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UESTA0X_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `NBUSYBK` reader - Busy Bank Flag"]
pub struct NBUSYBK_R(crate::FieldReader<u8, u8>);
impl NBUSYBK_R {
    pub(crate) fn new(bits: u8) -> Self {
        NBUSYBK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NBUSYBK_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NBUSYBK` writer - Busy Bank Flag"]
pub struct NBUSYBK_W<'a> {
    w: &'a mut W,
}
impl<'a> NBUSYBK_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `DTSEQ` reader - Data Toggle Sequencing Flag"]
pub struct DTSEQ_R(crate::FieldReader<u8, u8>);
impl DTSEQ_R {
    pub(crate) fn new(bits: u8) -> Self {
        DTSEQ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTSEQ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTSEQ` writer - Data Toggle Sequencing Flag"]
pub struct DTSEQ_W<'a> {
    w: &'a mut W,
}
impl<'a> DTSEQ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `UNDERFI` reader - Underflow Error Interrupt Flag"]
pub struct UNDERFI_R(crate::FieldReader<bool, bool>);
impl UNDERFI_R {
    pub(crate) fn new(bits: bool) -> Self {
        UNDERFI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UNDERFI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UNDERFI` writer - Underflow Error Interrupt Flag"]
pub struct UNDERFI_W<'a> {
    w: &'a mut W,
}
impl<'a> UNDERFI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `OVERFI` reader - Overflow Error Interrupt Flag"]
pub struct OVERFI_R(crate::FieldReader<bool, bool>);
impl OVERFI_R {
    pub(crate) fn new(bits: bool) -> Self {
        OVERFI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OVERFI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OVERFI` writer - Overflow Error Interrupt Flag"]
pub struct OVERFI_W<'a> {
    w: &'a mut W,
}
impl<'a> OVERFI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `CFGOK` reader - Configuration Status Flag"]
pub struct CFGOK_R(crate::FieldReader<bool, bool>);
impl CFGOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        CFGOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CFGOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CFGOK` writer - Configuration Status Flag"]
pub struct CFGOK_W<'a> {
    w: &'a mut W,
}
impl<'a> CFGOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Busy Bank Flag"]
    #[inline(always)]
    pub fn nbusybk(&self) -> NBUSYBK_R {
        NBUSYBK_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Data Toggle Sequencing Flag"]
    #[inline(always)]
    pub fn dtseq(&self) -> DTSEQ_R {
        DTSEQ_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 5 - Underflow Error Interrupt Flag"]
    #[inline(always)]
    pub fn underfi(&self) -> UNDERFI_R {
        UNDERFI_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Overflow Error Interrupt Flag"]
    #[inline(always)]
    pub fn overfi(&self) -> OVERFI_R {
        OVERFI_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Configuration Status Flag"]
    #[inline(always)]
    pub fn cfgok(&self) -> CFGOK_R {
        CFGOK_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Busy Bank Flag"]
    #[inline(always)]
    pub fn nbusybk(&mut self) -> NBUSYBK_W {
        NBUSYBK_W { w: self }
    }
    #[doc = "Bits 2:3 - Data Toggle Sequencing Flag"]
    #[inline(always)]
    pub fn dtseq(&mut self) -> DTSEQ_W {
        DTSEQ_W { w: self }
    }
    #[doc = "Bit 5 - Underflow Error Interrupt Flag"]
    #[inline(always)]
    pub fn underfi(&mut self) -> UNDERFI_W {
        UNDERFI_W { w: self }
    }
    #[doc = "Bit 6 - Overflow Error Interrupt Flag"]
    #[inline(always)]
    pub fn overfi(&mut self) -> OVERFI_W {
        OVERFI_W { w: self }
    }
    #[doc = "Bit 7 - Configuration Status Flag"]
    #[inline(always)]
    pub fn cfgok(&mut self) -> CFGOK_W {
        CFGOK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Endpoint Status 0 Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uesta0x](index.html) module"]
pub struct UESTA0X_SPEC;
impl crate::RegisterSpec for UESTA0X_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [uesta0x::R](R) reader structure"]
impl crate::Readable for UESTA0X_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [uesta0x::W](W) writer structure"]
impl crate::Writable for UESTA0X_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UESTA0X to value 0"]
impl crate::Resettable for UESTA0X_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
