#[doc = "Register `UEIENX` reader"]
pub struct R(crate::R<UEIENX_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UEIENX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UEIENX_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UEIENX_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UEIENX` writer"]
pub struct W(crate::W<UEIENX_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UEIENX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UEIENX_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UEIENX_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXINE` reader - Transmitter Ready Interrupt Enable Flag"]
pub struct TXINE_R(crate::FieldReader<bool, bool>);
impl TXINE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXINE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXINE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXINE` writer - Transmitter Ready Interrupt Enable Flag"]
pub struct TXINE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXINE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `STALLEDE` reader - Stalled Interrupt Enable Flag"]
pub struct STALLEDE_R(crate::FieldReader<bool, bool>);
impl STALLEDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        STALLEDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STALLEDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STALLEDE` writer - Stalled Interrupt Enable Flag"]
pub struct STALLEDE_W<'a> {
    w: &'a mut W,
}
impl<'a> STALLEDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RXOUTE` reader - Received OUT Data Interrupt Enable Flag"]
pub struct RXOUTE_R(crate::FieldReader<bool, bool>);
impl RXOUTE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXOUTE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXOUTE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXOUTE` writer - Received OUT Data Interrupt Enable Flag"]
pub struct RXOUTE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXOUTE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `RXSTPE` reader - Received SETUP Interrupt Enable Flag"]
pub struct RXSTPE_R(crate::FieldReader<bool, bool>);
impl RXSTPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSTPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSTPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXSTPE` writer - Received SETUP Interrupt Enable Flag"]
pub struct RXSTPE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXSTPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `NAKOUTE` reader - NAK OUT Interrupt Enable Bit"]
pub struct NAKOUTE_R(crate::FieldReader<bool, bool>);
impl NAKOUTE_R {
    pub(crate) fn new(bits: bool) -> Self {
        NAKOUTE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NAKOUTE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NAKOUTE` writer - NAK OUT Interrupt Enable Bit"]
pub struct NAKOUTE_W<'a> {
    w: &'a mut W,
}
impl<'a> NAKOUTE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `NAKINE` reader - NAK IN Interrupt Enable Bit"]
pub struct NAKINE_R(crate::FieldReader<bool, bool>);
impl NAKINE_R {
    pub(crate) fn new(bits: bool) -> Self {
        NAKINE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NAKINE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NAKINE` writer - NAK IN Interrupt Enable Bit"]
pub struct NAKINE_W<'a> {
    w: &'a mut W,
}
impl<'a> NAKINE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FLERRE` reader - Flow Error Interrupt Enable Flag"]
pub struct FLERRE_R(crate::FieldReader<bool, bool>);
impl FLERRE_R {
    pub(crate) fn new(bits: bool) -> Self {
        FLERRE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FLERRE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FLERRE` writer - Flow Error Interrupt Enable Flag"]
pub struct FLERRE_W<'a> {
    w: &'a mut W,
}
impl<'a> FLERRE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmitter Ready Interrupt Enable Flag"]
    #[inline(always)]
    pub fn txine(&self) -> TXINE_R {
        TXINE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Stalled Interrupt Enable Flag"]
    #[inline(always)]
    pub fn stallede(&self) -> STALLEDE_R {
        STALLEDE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Received OUT Data Interrupt Enable Flag"]
    #[inline(always)]
    pub fn rxoute(&self) -> RXOUTE_R {
        RXOUTE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Received SETUP Interrupt Enable Flag"]
    #[inline(always)]
    pub fn rxstpe(&self) -> RXSTPE_R {
        RXSTPE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - NAK OUT Interrupt Enable Bit"]
    #[inline(always)]
    pub fn nakoute(&self) -> NAKOUTE_R {
        NAKOUTE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - NAK IN Interrupt Enable Bit"]
    #[inline(always)]
    pub fn nakine(&self) -> NAKINE_R {
        NAKINE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Flow Error Interrupt Enable Flag"]
    #[inline(always)]
    pub fn flerre(&self) -> FLERRE_R {
        FLERRE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmitter Ready Interrupt Enable Flag"]
    #[inline(always)]
    pub fn txine(&mut self) -> TXINE_W {
        TXINE_W { w: self }
    }
    #[doc = "Bit 1 - Stalled Interrupt Enable Flag"]
    #[inline(always)]
    pub fn stallede(&mut self) -> STALLEDE_W {
        STALLEDE_W { w: self }
    }
    #[doc = "Bit 2 - Received OUT Data Interrupt Enable Flag"]
    #[inline(always)]
    pub fn rxoute(&mut self) -> RXOUTE_W {
        RXOUTE_W { w: self }
    }
    #[doc = "Bit 3 - Received SETUP Interrupt Enable Flag"]
    #[inline(always)]
    pub fn rxstpe(&mut self) -> RXSTPE_W {
        RXSTPE_W { w: self }
    }
    #[doc = "Bit 4 - NAK OUT Interrupt Enable Bit"]
    #[inline(always)]
    pub fn nakoute(&mut self) -> NAKOUTE_W {
        NAKOUTE_W { w: self }
    }
    #[doc = "Bit 6 - NAK IN Interrupt Enable Bit"]
    #[inline(always)]
    pub fn nakine(&mut self) -> NAKINE_W {
        NAKINE_W { w: self }
    }
    #[doc = "Bit 7 - Flow Error Interrupt Enable Flag"]
    #[inline(always)]
    pub fn flerre(&mut self) -> FLERRE_W {
        FLERRE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Endpoint Interrupt Enable Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ueienx](index.html) module"]
pub struct UEIENX_SPEC;
impl crate::RegisterSpec for UEIENX_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ueienx::R](R) reader structure"]
impl crate::Readable for UEIENX_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ueienx::W](W) writer structure"]
impl crate::Writable for UEIENX_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UEIENX to value 0"]
impl crate::Resettable for UEIENX_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
