#[doc = "Register `UEBCLX` reader"]
pub struct R(crate::R<UEBCLX_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UEBCLX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UEBCLX_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UEBCLX_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UEBCLX` writer"]
pub struct W(crate::W<UEBCLX_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UEBCLX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UEBCLX_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UEBCLX_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BYCT` reader - Byte Count bits"]
pub struct BYCT_R(crate::FieldReader<u8, u8>);
impl BYCT_R {
    pub(crate) fn new(bits: u8) -> Self {
        BYCT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BYCT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BYCT` writer - Byte Count bits"]
pub struct BYCT_W<'a> {
    w: &'a mut W,
}
impl<'a> BYCT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Byte Count bits"]
    #[inline(always)]
    pub fn byct(&self) -> BYCT_R {
        BYCT_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Byte Count bits"]
    #[inline(always)]
    pub fn byct(&mut self) -> BYCT_W {
        BYCT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Endpoint Byte Count Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uebclx](index.html) module"]
pub struct UEBCLX_SPEC;
impl crate::RegisterSpec for UEBCLX_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [uebclx::R](R) reader structure"]
impl crate::Readable for UEBCLX_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [uebclx::W](W) writer structure"]
impl crate::Writable for UEBCLX_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UEBCLX to value 0"]
impl crate::Resettable for UEBCLX_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
