#[doc = "Register `REGCR` reader"]
pub struct R(crate::R<REGCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<REGCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<REGCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<REGCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `REGCR` writer"]
pub struct W(crate::W<REGCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<REGCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<REGCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<REGCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `REGDIS` reader - Regulator Disable"]
pub struct REGDIS_R(crate::FieldReader<bool, bool>);
impl REGDIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        REGDIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REGDIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REGDIS` writer - Regulator Disable"]
pub struct REGDIS_W<'a> {
    w: &'a mut W,
}
impl<'a> REGDIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Regulator Disable"]
    #[inline(always)]
    pub fn regdis(&self) -> REGDIS_R {
        REGDIS_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Regulator Disable"]
    #[inline(always)]
    pub fn regdis(&mut self) -> REGDIS_W {
        REGDIS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Regulator Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [regcr](index.html) module"]
pub struct REGCR_SPEC;
impl crate::RegisterSpec for REGCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [regcr::R](R) reader structure"]
impl crate::Readable for REGCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [regcr::W](W) writer structure"]
impl crate::Writable for REGCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets REGCR to value 0"]
impl crate::Resettable for REGCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
