#[doc = "Register `EICRB` reader"]
pub struct R(crate::R<EICRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EICRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EICRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EICRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EICRB` writer"]
pub struct W(crate::W<EICRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EICRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EICRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EICRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ISC4` reader - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC4_R(crate::FieldReader<u8, u8>);
impl ISC4_R {
    pub(crate) fn new(bits: u8) -> Self {
        ISC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISC4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISC4` writer - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC4_W<'a> {
    w: &'a mut W,
}
impl<'a> ISC4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `ISC5` reader - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC5_R(crate::FieldReader<u8, u8>);
impl ISC5_R {
    pub(crate) fn new(bits: u8) -> Self {
        ISC5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISC5_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISC5` writer - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC5_W<'a> {
    w: &'a mut W,
}
impl<'a> ISC5_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `ISC6` reader - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC6_R(crate::FieldReader<u8, u8>);
impl ISC6_R {
    pub(crate) fn new(bits: u8) -> Self {
        ISC6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISC6_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISC6` writer - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC6_W<'a> {
    w: &'a mut W,
}
impl<'a> ISC6_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `ISC7` reader - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC7_R(crate::FieldReader<u8, u8>);
impl ISC7_R {
    pub(crate) fn new(bits: u8) -> Self {
        ISC7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISC7_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISC7` writer - External Interrupt 7-4 Sense Control Bit"]
pub struct ISC7_W<'a> {
    w: &'a mut W,
}
impl<'a> ISC7_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc4(&self) -> ISC4_R {
        ISC4_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc5(&self) -> ISC5_R {
        ISC5_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc6(&self) -> ISC6_R {
        ISC6_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc7(&self) -> ISC7_R {
        ISC7_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc4(&mut self) -> ISC4_W {
        ISC4_W { w: self }
    }
    #[doc = "Bits 2:3 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc5(&mut self) -> ISC5_W {
        ISC5_W { w: self }
    }
    #[doc = "Bits 4:5 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc6(&mut self) -> ISC6_W {
        ISC6_W { w: self }
    }
    #[doc = "Bits 6:7 - External Interrupt 7-4 Sense Control Bit"]
    #[inline(always)]
    pub fn isc7(&mut self) -> ISC7_W {
        ISC7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "External Interrupt Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [eicrb](index.html) module"]
pub struct EICRB_SPEC;
impl crate::RegisterSpec for EICRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [eicrb::R](R) reader structure"]
impl crate::Readable for EICRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [eicrb::W](W) writer structure"]
impl crate::Writable for EICRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EICRB to value 0"]
impl crate::Resettable for EICRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
