#[doc = "Register `PRR0` reader"]
pub struct R(crate::R<PRR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PRR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PRR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PRR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PRR0` writer"]
pub struct W(crate::W<PRR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PRR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PRR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PRR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PRSPI` reader - Power Reduction Serial Peripheral Interface"]
pub struct PRSPI_R(crate::FieldReader<bool, bool>);
impl PRSPI_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRSPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRSPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRSPI` writer - Power Reduction Serial Peripheral Interface"]
pub struct PRSPI_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PRTIM1` reader - Power Reduction Timer/Counter1"]
pub struct PRTIM1_R(crate::FieldReader<bool, bool>);
impl PRTIM1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM1` writer - Power Reduction Timer/Counter1"]
pub struct PRTIM1_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PRTIM0` reader - Power Reduction Timer/Counter0"]
pub struct PRTIM0_R(crate::FieldReader<bool, bool>);
impl PRTIM0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM0` writer - Power Reduction Timer/Counter0"]
pub struct PRTIM0_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface"]
    #[inline(always)]
    pub fn prspi(&self) -> PRSPI_R {
        PRSPI_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter1"]
    #[inline(always)]
    pub fn prtim1(&self) -> PRTIM1_R {
        PRTIM1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Power Reduction Timer/Counter0"]
    #[inline(always)]
    pub fn prtim0(&self) -> PRTIM0_R {
        PRTIM0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface"]
    #[inline(always)]
    pub fn prspi(&mut self) -> PRSPI_W {
        PRSPI_W { w: self }
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter1"]
    #[inline(always)]
    pub fn prtim1(&mut self) -> PRTIM1_W {
        PRTIM1_W { w: self }
    }
    #[doc = "Bit 5 - Power Reduction Timer/Counter0"]
    #[inline(always)]
    pub fn prtim0(&mut self) -> PRTIM0_W {
        PRTIM0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Power Reduction Register0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [prr0](index.html) module"]
pub struct PRR0_SPEC;
impl crate::RegisterSpec for PRR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [prr0::R](R) reader structure"]
impl crate::Readable for PRR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [prr0::W](W) writer structure"]
impl crate::Writable for PRR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PRR0 to value 0"]
impl crate::Resettable for PRR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
