#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - General Purpose IO Register 0"]
    pub gpior0: crate::Reg<gpior0::GPIOR0_SPEC>,
    _reserved1: [u8; 0x0b],
    #[doc = "0x0c - General Purpose IO Register 1"]
    pub gpior1: crate::Reg<gpior1::GPIOR1_SPEC>,
    #[doc = "0x0d - General Purpose IO Register 2"]
    pub gpior2: crate::Reg<gpior2::GPIOR2_SPEC>,
    _reserved3: [u8; 0x05],
    #[doc = "0x13 - debugWire communication register"]
    pub dwdr: crate::Reg<dwdr::DWDR_SPEC>,
    _reserved4: [u8; 0x01],
    #[doc = "0x15 - Sleep Mode Control Register"]
    pub smcr: crate::Reg<smcr::SMCR_SPEC>,
    #[doc = "0x16 - MCU Status Register"]
    pub mcusr: crate::Reg<mcusr::MCUSR_SPEC>,
    #[doc = "0x17 - MCU Control Register"]
    pub mcucr: crate::Reg<mcucr::MCUCR_SPEC>,
    _reserved7: [u8; 0x06],
    #[doc = "0x1e - Extended Indirect Register"]
    pub eind: crate::Reg<eind::EIND_SPEC>,
    _reserved8: [u8; 0x04],
    #[doc = "0x23 - No Description."]
    pub clkpr: crate::Reg<clkpr::CLKPR_SPEC>,
    _reserved9: [u8; 0x02],
    #[doc = "0x26 - Power Reduction Register0"]
    pub prr0: crate::Reg<prr0::PRR0_SPEC>,
    #[doc = "0x27 - Power Reduction Register1"]
    pub prr1: crate::Reg<prr1::PRR1_SPEC>,
    #[doc = "0x28 - Oscillator Calibration Value"]
    pub osccal: crate::Reg<osccal::OSCCAL_SPEC>,
    _reserved12: [u8; 0x69],
    #[doc = "0x92 - No Description."]
    pub clksel0: crate::Reg<clksel0::CLKSEL0_SPEC>,
    #[doc = "0x93 - No Description."]
    pub clksel1: crate::Reg<clksel1::CLKSEL1_SPEC>,
    #[doc = "0x94 - No Description."]
    pub clksta: crate::Reg<clksta::CLKSTA_SPEC>,
}
#[doc = "CLKPR register accessor: an alias for `Reg<CLKPR_SPEC>`"]
pub type CLKPR = crate::Reg<clkpr::CLKPR_SPEC>;
#[doc = "No Description."]
pub mod clkpr;
#[doc = "CLKSEL0 register accessor: an alias for `Reg<CLKSEL0_SPEC>`"]
pub type CLKSEL0 = crate::Reg<clksel0::CLKSEL0_SPEC>;
#[doc = "No Description."]
pub mod clksel0;
#[doc = "CLKSEL1 register accessor: an alias for `Reg<CLKSEL1_SPEC>`"]
pub type CLKSEL1 = crate::Reg<clksel1::CLKSEL1_SPEC>;
#[doc = "No Description."]
pub mod clksel1;
#[doc = "CLKSTA register accessor: an alias for `Reg<CLKSTA_SPEC>`"]
pub type CLKSTA = crate::Reg<clksta::CLKSTA_SPEC>;
#[doc = "No Description."]
pub mod clksta;
#[doc = "DWDR register accessor: an alias for `Reg<DWDR_SPEC>`"]
pub type DWDR = crate::Reg<dwdr::DWDR_SPEC>;
#[doc = "debugWire communication register"]
pub mod dwdr;
#[doc = "EIND register accessor: an alias for `Reg<EIND_SPEC>`"]
pub type EIND = crate::Reg<eind::EIND_SPEC>;
#[doc = "Extended Indirect Register"]
pub mod eind;
#[doc = "GPIOR0 register accessor: an alias for `Reg<GPIOR0_SPEC>`"]
pub type GPIOR0 = crate::Reg<gpior0::GPIOR0_SPEC>;
#[doc = "General Purpose IO Register 0"]
pub mod gpior0;
#[doc = "GPIOR1 register accessor: an alias for `Reg<GPIOR1_SPEC>`"]
pub type GPIOR1 = crate::Reg<gpior1::GPIOR1_SPEC>;
#[doc = "General Purpose IO Register 1"]
pub mod gpior1;
#[doc = "GPIOR2 register accessor: an alias for `Reg<GPIOR2_SPEC>`"]
pub type GPIOR2 = crate::Reg<gpior2::GPIOR2_SPEC>;
#[doc = "General Purpose IO Register 2"]
pub mod gpior2;
#[doc = "MCUCR register accessor: an alias for `Reg<MCUCR_SPEC>`"]
pub type MCUCR = crate::Reg<mcucr::MCUCR_SPEC>;
#[doc = "MCU Control Register"]
pub mod mcucr;
#[doc = "MCUSR register accessor: an alias for `Reg<MCUSR_SPEC>`"]
pub type MCUSR = crate::Reg<mcusr::MCUSR_SPEC>;
#[doc = "MCU Status Register"]
pub mod mcusr;
#[doc = "OSCCAL register accessor: an alias for `Reg<OSCCAL_SPEC>`"]
pub type OSCCAL = crate::Reg<osccal::OSCCAL_SPEC>;
#[doc = "Oscillator Calibration Value"]
pub mod osccal;
#[doc = "PRR0 register accessor: an alias for `Reg<PRR0_SPEC>`"]
pub type PRR0 = crate::Reg<prr0::PRR0_SPEC>;
#[doc = "Power Reduction Register0"]
pub mod prr0;
#[doc = "PRR1 register accessor: an alias for `Reg<PRR1_SPEC>`"]
pub type PRR1 = crate::Reg<prr1::PRR1_SPEC>;
#[doc = "Power Reduction Register1"]
pub mod prr1;
#[doc = "SMCR register accessor: an alias for `Reg<SMCR_SPEC>`"]
pub type SMCR = crate::Reg<smcr::SMCR_SPEC>;
#[doc = "Sleep Mode Control Register"]
pub mod smcr;
