#[doc = "Register `UCSRC` reader"]
pub struct R(crate::R<UCSRC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSRC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSRC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSRC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSRC` writer"]
pub struct W(crate::W<UCSRC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSRC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSRC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSRC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `UCPOL` reader - Clock Polarity"]
pub struct UCPOL_R(crate::FieldReader<bool, bool>);
impl UCPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCPOL` writer - Clock Polarity"]
pub struct UCPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> UCPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `UCSZ` reader - Character Size"]
pub struct UCSZ_R(crate::FieldReader<u8, u8>);
impl UCSZ_R {
    pub(crate) fn new(bits: u8) -> Self {
        UCSZ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCSZ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ` writer - Character Size"]
pub struct UCSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "Stop Bit Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum USBS_A {
    #[doc = "0: 1-bit"]
    VAL_0X00 = 0,
    #[doc = "1: 2-bit"]
    VAL_0X01 = 1,
}
impl From<USBS_A> for bool {
    #[inline(always)]
    fn from(variant: USBS_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `USBS` reader - Stop Bit Select"]
pub struct USBS_R(crate::FieldReader<bool, USBS_A>);
impl USBS_R {
    pub(crate) fn new(bits: bool) -> Self {
        USBS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> USBS_A {
        match self.bits {
            false => USBS_A::VAL_0X00,
            true => USBS_A::VAL_0X01,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == USBS_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == USBS_A::VAL_0X01
    }
}
impl core::ops::Deref for USBS_R {
    type Target = crate::FieldReader<bool, USBS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBS` writer - Stop Bit Select"]
pub struct USBS_W<'a> {
    w: &'a mut W,
}
impl<'a> USBS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: USBS_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "1-bit"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(USBS_A::VAL_0X00)
    }
    #[doc = "2-bit"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(USBS_A::VAL_0X01)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Parity Mode Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UPM_A {
    #[doc = "0: Disabled"]
    VAL_0X00 = 0,
    #[doc = "1: Reserved"]
    VAL_0X01 = 1,
    #[doc = "2: Enabled, Even Parity"]
    VAL_0X02 = 2,
    #[doc = "3: Enabled, Odd Parity"]
    VAL_0X03 = 3,
}
impl From<UPM_A> for u8 {
    #[inline(always)]
    fn from(variant: UPM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UPM` reader - Parity Mode Bits"]
pub struct UPM_R(crate::FieldReader<u8, UPM_A>);
impl UPM_R {
    pub(crate) fn new(bits: u8) -> Self {
        UPM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UPM_A {
        match self.bits {
            0 => UPM_A::VAL_0X00,
            1 => UPM_A::VAL_0X01,
            2 => UPM_A::VAL_0X02,
            3 => UPM_A::VAL_0X03,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == UPM_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == UPM_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == UPM_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == UPM_A::VAL_0X03
    }
}
impl core::ops::Deref for UPM_R {
    type Target = crate::FieldReader<u8, UPM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPM` writer - Parity Mode Bits"]
pub struct UPM_W<'a> {
    w: &'a mut W,
}
impl<'a> UPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UPM_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Disabled"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(UPM_A::VAL_0X00)
    }
    #[doc = "Reserved"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(UPM_A::VAL_0X01)
    }
    #[doc = "Enabled, Even Parity"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(UPM_A::VAL_0X02)
    }
    #[doc = "Enabled, Odd Parity"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(UPM_A::VAL_0X03)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "USART Mode Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum UMSEL_A {
    #[doc = "0: Asynchronous Operation"]
    VAL_0X00 = 0,
    #[doc = "1: Synchronous Operation"]
    VAL_0X01 = 1,
}
impl From<UMSEL_A> for bool {
    #[inline(always)]
    fn from(variant: UMSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `UMSEL` reader - USART Mode Select"]
pub struct UMSEL_R(crate::FieldReader<bool, UMSEL_A>);
impl UMSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        UMSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UMSEL_A {
        match self.bits {
            false => UMSEL_A::VAL_0X00,
            true => UMSEL_A::VAL_0X01,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == UMSEL_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == UMSEL_A::VAL_0X01
    }
}
impl core::ops::Deref for UMSEL_R {
    type Target = crate::FieldReader<bool, UMSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UMSEL` writer - USART Mode Select"]
pub struct UMSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> UMSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UMSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Asynchronous Operation"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(UMSEL_A::VAL_0X00)
    }
    #[doc = "Synchronous Operation"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(UMSEL_A::VAL_0X01)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `URSEL` reader - Register Select"]
pub struct URSEL_R(crate::FieldReader<bool, bool>);
impl URSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        URSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for URSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `URSEL` writer - Register Select"]
pub struct URSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> URSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol(&self) -> UCPOL_R {
        UCPOL_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Character Size"]
    #[inline(always)]
    pub fn ucsz(&self) -> UCSZ_R {
        UCSZ_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs(&self) -> USBS_R {
        USBS_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm(&self) -> UPM_R {
        UPM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel(&self) -> UMSEL_R {
        UMSEL_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Register Select"]
    #[inline(always)]
    pub fn ursel(&self) -> URSEL_R {
        URSEL_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol(&mut self) -> UCPOL_W {
        UCPOL_W { w: self }
    }
    #[doc = "Bits 1:2 - Character Size"]
    #[inline(always)]
    pub fn ucsz(&mut self) -> UCSZ_W {
        UCSZ_W { w: self }
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs(&mut self) -> USBS_W {
        USBS_W { w: self }
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm(&mut self) -> UPM_W {
        UPM_W { w: self }
    }
    #[doc = "Bit 6 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel(&mut self) -> UMSEL_W {
        UMSEL_W { w: self }
    }
    #[doc = "Bit 7 - Register Select"]
    #[inline(always)]
    pub fn ursel(&mut self) -> URSEL_W {
        URSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsrc](index.html) module"]
pub struct UCSRC_SPEC;
impl crate::RegisterSpec for UCSRC_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsrc::R](R) reader structure"]
impl crate::Readable for UCSRC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsrc::W](W) writer structure"]
impl crate::Writable for UCSRC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSRC to value 0"]
impl crate::Resettable for UCSRC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
