#[doc = "Register `TIMSK` reader"]
pub struct R(crate::R<TIMSK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK` writer"]
pub struct W(crate::W<TIMSK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE2` reader - Timer/Counter2 Overflow Interrupt Enable"]
pub struct TOIE2_R(crate::FieldReader<bool, bool>);
impl TOIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE2` writer - Timer/Counter2 Overflow Interrupt Enable"]
pub struct TOIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `OCIE2` reader - Timer/Counter2 Output Compare Match Interrupt Enable"]
pub struct OCIE2_R(crate::FieldReader<bool, bool>);
impl OCIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE2` writer - Timer/Counter2 Output Compare Match Interrupt Enable"]
pub struct OCIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 6 - Timer/Counter2 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie2(&self) -> TOIE2_R {
        TOIE2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Timer/Counter2 Output Compare Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2(&self) -> OCIE2_R {
        OCIE2_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 6 - Timer/Counter2 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie2(&mut self) -> TOIE2_W {
        TOIE2_W { w: self }
    }
    #[doc = "Bit 7 - Timer/Counter2 Output Compare Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2(&mut self) -> OCIE2_W {
        OCIE2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Interrupt Mask register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk](index.html) module"]
pub struct TIMSK_SPEC;
impl crate::RegisterSpec for TIMSK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk::R](R) reader structure"]
impl crate::Readable for TIMSK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk::W](W) writer structure"]
impl crate::Writable for TIMSK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK to value 0"]
impl crate::Resettable for TIMSK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
