#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Asynchronous Status Register"]
    pub assr: crate::Reg<assr::ASSR_SPEC>,
    #[doc = "0x01 - Timer/Counter2 Output Compare Register"]
    pub ocr2: crate::Reg<ocr2::OCR2_SPEC>,
    #[doc = "0x02 - Timer/Counter2"]
    pub tcnt2: crate::Reg<tcnt2::TCNT2_SPEC>,
    #[doc = "0x03 - Timer/Counter2 Control Register"]
    pub tccr2: crate::Reg<tccr2::TCCR2_SPEC>,
    _reserved4: [u8; 0x0a],
    #[doc = "0x0e - Special Function IO Register"]
    pub sfior: crate::Reg<sfior::SFIOR_SPEC>,
    _reserved5: [u8; 0x07],
    #[doc = "0x16 - Timer/Counter Interrupt Flag Register"]
    pub tifr: crate::Reg<tifr::TIFR_SPEC>,
    #[doc = "0x17 - Timer/Counter Interrupt Mask register"]
    pub timsk: crate::Reg<timsk::TIMSK_SPEC>,
}
#[doc = "ASSR register accessor: an alias for `Reg<ASSR_SPEC>`"]
pub type ASSR = crate::Reg<assr::ASSR_SPEC>;
#[doc = "Asynchronous Status Register"]
pub mod assr;
#[doc = "OCR2 register accessor: an alias for `Reg<OCR2_SPEC>`"]
pub type OCR2 = crate::Reg<ocr2::OCR2_SPEC>;
#[doc = "Timer/Counter2 Output Compare Register"]
pub mod ocr2;
#[doc = "SFIOR register accessor: an alias for `Reg<SFIOR_SPEC>`"]
pub type SFIOR = crate::Reg<sfior::SFIOR_SPEC>;
#[doc = "Special Function IO Register"]
pub mod sfior;
#[doc = "TCCR2 register accessor: an alias for `Reg<TCCR2_SPEC>`"]
pub type TCCR2 = crate::Reg<tccr2::TCCR2_SPEC>;
#[doc = "Timer/Counter2 Control Register"]
pub mod tccr2;
#[doc = "TCNT2 register accessor: an alias for `Reg<TCNT2_SPEC>`"]
pub type TCNT2 = crate::Reg<tcnt2::TCNT2_SPEC>;
#[doc = "Timer/Counter2"]
pub mod tcnt2;
#[doc = "TIFR register accessor: an alias for `Reg<TIFR_SPEC>`"]
pub type TIFR = crate::Reg<tifr::TIFR_SPEC>;
#[doc = "Timer/Counter Interrupt Flag Register"]
pub mod tifr;
#[doc = "TIMSK register accessor: an alias for `Reg<TIMSK_SPEC>`"]
pub type TIMSK = crate::Reg<timsk::TIMSK_SPEC>;
#[doc = "Timer/Counter Interrupt Mask register"]
pub mod timsk;
