#[doc = "Register `TCCR0` reader"]
pub struct R(crate::R<TCCR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR0` writer"]
pub struct W(crate::W<TCCR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select0 bit 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CS00_A {
    #[doc = "0: No Clock Source (Stopped)"]
    VAL_0X00 = 0,
    #[doc = "1: Running, No Prescaling"]
    VAL_0X01 = 1,
}
impl From<CS00_A> for bool {
    #[inline(always)]
    fn from(variant: CS00_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CS00` reader - Clock Select0 bit 0"]
pub struct CS00_R(crate::FieldReader<bool, CS00_A>);
impl CS00_R {
    pub(crate) fn new(bits: bool) -> Self {
        CS00_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS00_A {
        match self.bits {
            false => CS00_A::VAL_0X00,
            true => CS00_A::VAL_0X01,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == CS00_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == CS00_A::VAL_0X01
    }
}
impl core::ops::Deref for CS00_R {
    type Target = crate::FieldReader<bool, CS00_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS00` writer - Clock Select0 bit 0"]
pub struct CS00_W<'a> {
    w: &'a mut W,
}
impl<'a> CS00_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS00_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No Clock Source (Stopped)"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(CS00_A::VAL_0X00)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(CS00_A::VAL_0X01)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `CS01` reader - Clock Select0 bit 1"]
pub struct CS01_R(crate::FieldReader<bool, bool>);
impl CS01_R {
    pub(crate) fn new(bits: bool) -> Self {
        CS01_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CS01_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS01` writer - Clock Select0 bit 1"]
pub struct CS01_W<'a> {
    w: &'a mut W,
}
impl<'a> CS01_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CS02` reader - Clock Select0 bit 2"]
pub struct CS02_R(crate::FieldReader<bool, bool>);
impl CS02_R {
    pub(crate) fn new(bits: bool) -> Self {
        CS02_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CS02_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS02` writer - Clock Select0 bit 2"]
pub struct CS02_W<'a> {
    w: &'a mut W,
}
impl<'a> CS02_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Clock Select0 bit 0"]
    #[inline(always)]
    pub fn cs00(&self) -> CS00_R {
        CS00_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Clock Select0 bit 1"]
    #[inline(always)]
    pub fn cs01(&self) -> CS01_R {
        CS01_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Clock Select0 bit 2"]
    #[inline(always)]
    pub fn cs02(&self) -> CS02_R {
        CS02_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Clock Select0 bit 0"]
    #[inline(always)]
    pub fn cs00(&mut self) -> CS00_W {
        CS00_W { w: self }
    }
    #[doc = "Bit 1 - Clock Select0 bit 1"]
    #[inline(always)]
    pub fn cs01(&mut self) -> CS01_W {
        CS01_W { w: self }
    }
    #[doc = "Bit 2 - Clock Select0 bit 2"]
    #[inline(always)]
    pub fn cs02(&mut self) -> CS02_W {
        CS02_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter0 Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr0](index.html) module"]
pub struct TCCR0_SPEC;
impl crate::RegisterSpec for TCCR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr0::R](R) reader structure"]
impl crate::Readable for TCCR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr0::W](W) writer structure"]
impl crate::Writable for TCCR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR0 to value 0"]
impl crate::Resettable for TCCR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
