#[doc = "Register `SPSR` reader"]
pub struct R(crate::R<SPSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPSR` writer"]
pub struct W(crate::W<SPSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SPI2X` reader - Double SPI Speed Bit"]
pub struct SPI2X_R(crate::FieldReader<bool, bool>);
impl SPI2X_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI2X_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI2X_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPI2X` writer - Double SPI Speed Bit"]
pub struct SPI2X_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI2X_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `WCOL` reader - Write Collision Flag"]
pub struct WCOL_R(crate::FieldReader<bool, bool>);
impl WCOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        WCOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WCOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WCOL` writer - Write Collision Flag"]
pub struct WCOL_W<'a> {
    w: &'a mut W,
}
impl<'a> WCOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `SPIF` reader - SPI Interrupt Flag"]
pub struct SPIF_R(crate::FieldReader<bool, bool>);
impl SPIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPIF` writer - SPI Interrupt Flag"]
pub struct SPIF_W<'a> {
    w: &'a mut W,
}
impl<'a> SPIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Double SPI Speed Bit"]
    #[inline(always)]
    pub fn spi2x(&self) -> SPI2X_R {
        SPI2X_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 6 - Write Collision Flag"]
    #[inline(always)]
    pub fn wcol(&self) -> WCOL_R {
        WCOL_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - SPI Interrupt Flag"]
    #[inline(always)]
    pub fn spif(&self) -> SPIF_R {
        SPIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Double SPI Speed Bit"]
    #[inline(always)]
    pub fn spi2x(&mut self) -> SPI2X_W {
        SPI2X_W { w: self }
    }
    #[doc = "Bit 6 - Write Collision Flag"]
    #[inline(always)]
    pub fn wcol(&mut self) -> WCOL_W {
        WCOL_W { w: self }
    }
    #[doc = "Bit 7 - SPI Interrupt Flag"]
    #[inline(always)]
    pub fn spif(&mut self) -> SPIF_W {
        SPIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SPI Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spsr](index.html) module"]
pub struct SPSR_SPEC;
impl crate::RegisterSpec for SPSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [spsr::R](R) reader structure"]
impl crate::Readable for SPSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spsr::W](W) writer structure"]
impl crate::Writable for SPSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPSR to value 0"]
impl crate::Resettable for SPSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
