#[doc = "Register `GICR` reader"]
pub struct R(crate::R<GICR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GICR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GICR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GICR` writer"]
pub struct W(crate::W<GICR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GICR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GICR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GICR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IVCE` reader - Interrupt Vector Change Enable"]
pub struct IVCE_R(crate::FieldReader<bool, bool>);
impl IVCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        IVCE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IVCE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IVCE` writer - Interrupt Vector Change Enable"]
pub struct IVCE_W<'a> {
    w: &'a mut W,
}
impl<'a> IVCE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `IVSEL` reader - Interrupt Vector Select"]
pub struct IVSEL_R(crate::FieldReader<bool, bool>);
impl IVSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        IVSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IVSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IVSEL` writer - Interrupt Vector Select"]
pub struct IVSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> IVSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `INT` reader - External Interrupt Request 1 Enable"]
pub struct INT_R(crate::FieldReader<u8, u8>);
impl INT_R {
    pub(crate) fn new(bits: u8) -> Self {
        INT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INT` writer - External Interrupt Request 1 Enable"]
pub struct INT_W<'a> {
    w: &'a mut W,
}
impl<'a> INT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Interrupt Vector Change Enable"]
    #[inline(always)]
    pub fn ivce(&self) -> IVCE_R {
        IVCE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Interrupt Vector Select"]
    #[inline(always)]
    pub fn ivsel(&self) -> IVSEL_R {
        IVSEL_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 6:7 - External Interrupt Request 1 Enable"]
    #[inline(always)]
    pub fn int(&self) -> INT_R {
        INT_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Interrupt Vector Change Enable"]
    #[inline(always)]
    pub fn ivce(&mut self) -> IVCE_W {
        IVCE_W { w: self }
    }
    #[doc = "Bit 1 - Interrupt Vector Select"]
    #[inline(always)]
    pub fn ivsel(&mut self) -> IVSEL_W {
        IVSEL_W { w: self }
    }
    #[doc = "Bits 6:7 - External Interrupt Request 1 Enable"]
    #[inline(always)]
    pub fn int(&mut self) -> INT_W {
        INT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Interrupt Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gicr](index.html) module"]
pub struct GICR_SPEC;
impl crate::RegisterSpec for GICR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gicr::R](R) reader structure"]
impl crate::Readable for GICR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gicr::W](W) writer structure"]
impl crate::Writable for GICR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GICR to value 0"]
impl crate::Resettable for GICR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
