#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Special Function IO Register"]
    pub sfior: crate::Reg<sfior::SFIOR_SPEC>,
    #[doc = "0x01 - Oscillator Calibration Value"]
    pub osccal: crate::Reg<osccal::OSCCAL_SPEC>,
    _reserved2: [u8; 0x02],
    #[doc = "0x04 - MCU Control And Status Register"]
    pub mcucsr: crate::Reg<mcucsr::MCUCSR_SPEC>,
    #[doc = "0x05 - MCU Control Register"]
    pub mcucr: crate::Reg<mcucr::MCUCR_SPEC>,
    _reserved4: [u8; 0x01],
    #[doc = "0x07 - Store Program Memory Control Register"]
    pub spmcr: crate::Reg<spmcr::SPMCR_SPEC>,
}
#[doc = "MCUCR register accessor: an alias for `Reg<MCUCR_SPEC>`"]
pub type MCUCR = crate::Reg<mcucr::MCUCR_SPEC>;
#[doc = "MCU Control Register"]
pub mod mcucr;
#[doc = "MCUCSR register accessor: an alias for `Reg<MCUCSR_SPEC>`"]
pub type MCUCSR = crate::Reg<mcucsr::MCUCSR_SPEC>;
#[doc = "MCU Control And Status Register"]
pub mod mcucsr;
#[doc = "OSCCAL register accessor: an alias for `Reg<OSCCAL_SPEC>`"]
pub type OSCCAL = crate::Reg<osccal::OSCCAL_SPEC>;
#[doc = "Oscillator Calibration Value"]
pub mod osccal;
#[doc = "SFIOR register accessor: an alias for `Reg<SFIOR_SPEC>`"]
pub type SFIOR = crate::Reg<sfior::SFIOR_SPEC>;
#[doc = "Special Function IO Register"]
pub mod sfior;
#[doc = "SPMCR register accessor: an alias for `Reg<SPMCR_SPEC>`"]
pub type SPMCR = crate::Reg<spmcr::SPMCR_SPEC>;
#[doc = "Store Program Memory Control Register"]
pub mod spmcr;
