#[doc = "Register `TCCR2` reader"]
pub struct R(crate::R<TCCR2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR2` writer"]
pub struct W(crate::W<TCCR2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS2_A {
    #[doc = "0: No Clock Source (Stopped)"]
    VAL_0X00 = 0,
    #[doc = "1: Running, No Prescaling"]
    VAL_0X01 = 1,
    #[doc = "2: Running, CLK/8"]
    VAL_0X02 = 2,
    #[doc = "3: Running, CLK/64"]
    VAL_0X03 = 3,
    #[doc = "4: Running, CLK/256"]
    VAL_0X04 = 4,
    #[doc = "5: Running, CLK/1024"]
    VAL_0X05 = 5,
    #[doc = "6: Running, ExtClk Tx Falling Edge"]
    VAL_0X06 = 6,
    #[doc = "7: Running, ExtClk Tx Rising Edge"]
    VAL_0X07 = 7,
}
impl From<CS2_A> for u8 {
    #[inline(always)]
    fn from(variant: CS2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS2` reader - Clock Select"]
pub struct CS2_R(crate::FieldReader<u8, CS2_A>);
impl CS2_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS2_A {
        match self.bits {
            0 => CS2_A::VAL_0X00,
            1 => CS2_A::VAL_0X01,
            2 => CS2_A::VAL_0X02,
            3 => CS2_A::VAL_0X03,
            4 => CS2_A::VAL_0X04,
            5 => CS2_A::VAL_0X05,
            6 => CS2_A::VAL_0X06,
            7 => CS2_A::VAL_0X07,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == CS2_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == CS2_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == CS2_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == CS2_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == CS2_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == CS2_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == CS2_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == CS2_A::VAL_0X07
    }
}
impl core::ops::Deref for CS2_R {
    type Target = crate::FieldReader<u8, CS2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS2` writer - Clock Select"]
pub struct CS2_W<'a> {
    w: &'a mut W,
}
impl<'a> CS2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS2_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No Clock Source (Stopped)"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X00)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X01)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X02)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X03)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X04)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X05)
    }
    #[doc = "Running, ExtClk Tx Falling Edge"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X06)
    }
    #[doc = "Running, ExtClk Tx Rising Edge"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(CS2_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM21` reader - Waveform Generation Mode"]
pub struct WGM21_R(crate::FieldReader<bool, bool>);
impl WGM21_R {
    pub(crate) fn new(bits: bool) -> Self {
        WGM21_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM21_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM21` writer - Waveform Generation Mode"]
pub struct WGM21_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM21_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `COM2` reader - Compare Match Output Mode"]
pub struct COM2_R(crate::FieldReader<u8, u8>);
impl COM2_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM2` writer - Compare Match Output Mode"]
pub struct COM2_W<'a> {
    w: &'a mut W,
}
impl<'a> COM2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Wafeform Generation Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum WGM20_A {
    #[doc = "0: Normal"]
    VAL_0X00 = 0,
    #[doc = "1: CTC"]
    VAL_0X01 = 1,
}
impl From<WGM20_A> for bool {
    #[inline(always)]
    fn from(variant: WGM20_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `WGM20` reader - Wafeform Generation Mode"]
pub struct WGM20_R(crate::FieldReader<bool, WGM20_A>);
impl WGM20_R {
    pub(crate) fn new(bits: bool) -> Self {
        WGM20_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGM20_A {
        match self.bits {
            false => WGM20_A::VAL_0X00,
            true => WGM20_A::VAL_0X01,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == WGM20_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == WGM20_A::VAL_0X01
    }
}
impl core::ops::Deref for WGM20_R {
    type Target = crate::FieldReader<bool, WGM20_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM20` writer - Wafeform Generation Mode"]
pub struct WGM20_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGM20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Normal"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(WGM20_A::VAL_0X00)
    }
    #[doc = "CTC"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(WGM20_A::VAL_0X01)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FOC2` reader - Force Output Compare"]
pub struct FOC2_R(crate::FieldReader<bool, bool>);
impl FOC2_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC2` writer - Force Output Compare"]
pub struct FOC2_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs2(&self) -> CS2_R {
        CS2_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm21(&self) -> WGM21_R {
        WGM21_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Compare Match Output Mode"]
    #[inline(always)]
    pub fn com2(&self) -> COM2_R {
        COM2_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Wafeform Generation Mode"]
    #[inline(always)]
    pub fn wgm20(&self) -> WGM20_R {
        WGM20_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Force Output Compare"]
    #[inline(always)]
    pub fn foc2(&self) -> FOC2_R {
        FOC2_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs2(&mut self) -> CS2_W {
        CS2_W { w: self }
    }
    #[doc = "Bit 3 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm21(&mut self) -> WGM21_W {
        WGM21_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Match Output Mode"]
    #[inline(always)]
    pub fn com2(&mut self) -> COM2_W {
        COM2_W { w: self }
    }
    #[doc = "Bit 6 - Wafeform Generation Mode"]
    #[inline(always)]
    pub fn wgm20(&mut self) -> WGM20_W {
        WGM20_W { w: self }
    }
    #[doc = "Bit 7 - Force Output Compare"]
    #[inline(always)]
    pub fn foc2(&mut self) -> FOC2_W {
        FOC2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr2](index.html) module"]
pub struct TCCR2_SPEC;
impl crate::RegisterSpec for TCCR2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr2::R](R) reader structure"]
impl crate::Readable for TCCR2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr2::W](W) writer structure"]
impl crate::Writable for TCCR2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR2 to value 0"]
impl crate::Resettable for TCCR2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
