#[doc = "Register `ETIMSK` reader"]
pub struct R(crate::R<ETIMSK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ETIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ETIMSK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ETIMSK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ETIMSK` writer"]
pub struct W(crate::W<ETIMSK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ETIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ETIMSK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ETIMSK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `OCIE1C` reader - Timer/Counter 1, Output Compare Match C Interrupt Enable"]
pub struct OCIE1C_R(crate::FieldReader<bool, bool>);
impl OCIE1C_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE1C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE1C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE1C` writer - Timer/Counter 1, Output Compare Match C Interrupt Enable"]
pub struct OCIE1C_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE1C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter 1, Output Compare Match C Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1c(&self) -> OCIE1C_R {
        OCIE1C_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter 1, Output Compare Match C Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1c(&mut self) -> OCIE1C_W {
        OCIE1C_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Extended Timer/Counter Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [etimsk](index.html) module"]
pub struct ETIMSK_SPEC;
impl crate::RegisterSpec for ETIMSK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [etimsk::R](R) reader structure"]
impl crate::Readable for ETIMSK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [etimsk::W](W) writer structure"]
impl crate::Writable for ETIMSK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ETIMSK to value 0"]
impl crate::Resettable for ETIMSK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
