#[doc = "Register `LOCKBIT` reader"]
pub struct R(crate::R<LOCKBIT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LOCKBIT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LOCKBIT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LOCKBIT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LOCKBIT` writer"]
pub struct W(crate::W<LOCKBIT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LOCKBIT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LOCKBIT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LOCKBIT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Memory Lock\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum LB_A {
    #[doc = "0: Further programming and verification disabled"]
    PROG_VER_DISABLED = 0,
    #[doc = "2: Further programming disabled"]
    PROG_DISABLED = 2,
    #[doc = "3: No memory lock features enabled"]
    NO_LOCK = 3,
}
impl From<LB_A> for u8 {
    #[inline(always)]
    fn from(variant: LB_A) -> Self {
        variant as _
    }
}
#[doc = "Field `LB` reader - Memory Lock"]
pub struct LB_R(crate::FieldReader<u8, LB_A>);
impl LB_R {
    pub(crate) fn new(bits: u8) -> Self {
        LB_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<LB_A> {
        match self.bits {
            0 => Some(LB_A::PROG_VER_DISABLED),
            2 => Some(LB_A::PROG_DISABLED),
            3 => Some(LB_A::NO_LOCK),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `PROG_VER_DISABLED`"]
    #[inline(always)]
    pub fn is_prog_ver_disabled(&self) -> bool {
        **self == LB_A::PROG_VER_DISABLED
    }
    #[doc = "Checks if the value of the field is `PROG_DISABLED`"]
    #[inline(always)]
    pub fn is_prog_disabled(&self) -> bool {
        **self == LB_A::PROG_DISABLED
    }
    #[doc = "Checks if the value of the field is `NO_LOCK`"]
    #[inline(always)]
    pub fn is_no_lock(&self) -> bool {
        **self == LB_A::NO_LOCK
    }
}
impl core::ops::Deref for LB_R {
    type Target = crate::FieldReader<u8, LB_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LB` writer - Memory Lock"]
pub struct LB_W<'a> {
    w: &'a mut W,
}
impl<'a> LB_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LB_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Further programming and verification disabled"]
    #[inline(always)]
    pub fn prog_ver_disabled(self) -> &'a mut W {
        self.variant(LB_A::PROG_VER_DISABLED)
    }
    #[doc = "Further programming disabled"]
    #[inline(always)]
    pub fn prog_disabled(self) -> &'a mut W {
        self.variant(LB_A::PROG_DISABLED)
    }
    #[doc = "No memory lock features enabled"]
    #[inline(always)]
    pub fn no_lock(self) -> &'a mut W {
        self.variant(LB_A::NO_LOCK)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Boot Loader Protection Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BLB0_A {
    #[doc = "0: LPM and SPM prohibited in Application Section"]
    LPM_SPM_DISABLE = 0,
    #[doc = "1: LPM prohibited in Application Section"]
    LPM_DISABLE = 1,
    #[doc = "2: SPM prohibited in Application Section"]
    SPM_DISABLE = 2,
    #[doc = "3: No lock on SPM and LPM in Application Section"]
    NO_LOCK = 3,
}
impl From<BLB0_A> for u8 {
    #[inline(always)]
    fn from(variant: BLB0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BLB0` reader - Boot Loader Protection Mode"]
pub struct BLB0_R(crate::FieldReader<u8, BLB0_A>);
impl BLB0_R {
    pub(crate) fn new(bits: u8) -> Self {
        BLB0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BLB0_A {
        match self.bits {
            0 => BLB0_A::LPM_SPM_DISABLE,
            1 => BLB0_A::LPM_DISABLE,
            2 => BLB0_A::SPM_DISABLE,
            3 => BLB0_A::NO_LOCK,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `LPM_SPM_DISABLE`"]
    #[inline(always)]
    pub fn is_lpm_spm_disable(&self) -> bool {
        **self == BLB0_A::LPM_SPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `LPM_DISABLE`"]
    #[inline(always)]
    pub fn is_lpm_disable(&self) -> bool {
        **self == BLB0_A::LPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `SPM_DISABLE`"]
    #[inline(always)]
    pub fn is_spm_disable(&self) -> bool {
        **self == BLB0_A::SPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `NO_LOCK`"]
    #[inline(always)]
    pub fn is_no_lock(&self) -> bool {
        **self == BLB0_A::NO_LOCK
    }
}
impl core::ops::Deref for BLB0_R {
    type Target = crate::FieldReader<u8, BLB0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BLB0` writer - Boot Loader Protection Mode"]
pub struct BLB0_W<'a> {
    w: &'a mut W,
}
impl<'a> BLB0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BLB0_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "LPM and SPM prohibited in Application Section"]
    #[inline(always)]
    pub fn lpm_spm_disable(self) -> &'a mut W {
        self.variant(BLB0_A::LPM_SPM_DISABLE)
    }
    #[doc = "LPM prohibited in Application Section"]
    #[inline(always)]
    pub fn lpm_disable(self) -> &'a mut W {
        self.variant(BLB0_A::LPM_DISABLE)
    }
    #[doc = "SPM prohibited in Application Section"]
    #[inline(always)]
    pub fn spm_disable(self) -> &'a mut W {
        self.variant(BLB0_A::SPM_DISABLE)
    }
    #[doc = "No lock on SPM and LPM in Application Section"]
    #[inline(always)]
    pub fn no_lock(self) -> &'a mut W {
        self.variant(BLB0_A::NO_LOCK)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Boot Loader Protection Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BLB1_A {
    #[doc = "0: LPM and SPM prohibited in Boot Section"]
    LPM_SPM_DISABLE = 0,
    #[doc = "1: LPM prohibited in Boot Section"]
    LPM_DISABLE = 1,
    #[doc = "2: SPM prohibited in Boot Section"]
    SPM_DISABLE = 2,
    #[doc = "3: No lock on SPM and LPM in Boot Section"]
    NO_LOCK = 3,
}
impl From<BLB1_A> for u8 {
    #[inline(always)]
    fn from(variant: BLB1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BLB1` reader - Boot Loader Protection Mode"]
pub struct BLB1_R(crate::FieldReader<u8, BLB1_A>);
impl BLB1_R {
    pub(crate) fn new(bits: u8) -> Self {
        BLB1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BLB1_A {
        match self.bits {
            0 => BLB1_A::LPM_SPM_DISABLE,
            1 => BLB1_A::LPM_DISABLE,
            2 => BLB1_A::SPM_DISABLE,
            3 => BLB1_A::NO_LOCK,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `LPM_SPM_DISABLE`"]
    #[inline(always)]
    pub fn is_lpm_spm_disable(&self) -> bool {
        **self == BLB1_A::LPM_SPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `LPM_DISABLE`"]
    #[inline(always)]
    pub fn is_lpm_disable(&self) -> bool {
        **self == BLB1_A::LPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `SPM_DISABLE`"]
    #[inline(always)]
    pub fn is_spm_disable(&self) -> bool {
        **self == BLB1_A::SPM_DISABLE
    }
    #[doc = "Checks if the value of the field is `NO_LOCK`"]
    #[inline(always)]
    pub fn is_no_lock(&self) -> bool {
        **self == BLB1_A::NO_LOCK
    }
}
impl core::ops::Deref for BLB1_R {
    type Target = crate::FieldReader<u8, BLB1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BLB1` writer - Boot Loader Protection Mode"]
pub struct BLB1_W<'a> {
    w: &'a mut W,
}
impl<'a> BLB1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BLB1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "LPM and SPM prohibited in Boot Section"]
    #[inline(always)]
    pub fn lpm_spm_disable(self) -> &'a mut W {
        self.variant(BLB1_A::LPM_SPM_DISABLE)
    }
    #[doc = "LPM prohibited in Boot Section"]
    #[inline(always)]
    pub fn lpm_disable(self) -> &'a mut W {
        self.variant(BLB1_A::LPM_DISABLE)
    }
    #[doc = "SPM prohibited in Boot Section"]
    #[inline(always)]
    pub fn spm_disable(self) -> &'a mut W {
        self.variant(BLB1_A::SPM_DISABLE)
    }
    #[doc = "No lock on SPM and LPM in Boot Section"]
    #[inline(always)]
    pub fn no_lock(self) -> &'a mut W {
        self.variant(BLB1_A::NO_LOCK)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Memory Lock"]
    #[inline(always)]
    pub fn lb(&self) -> LB_R {
        LB_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Boot Loader Protection Mode"]
    #[inline(always)]
    pub fn blb0(&self) -> BLB0_R {
        BLB0_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Boot Loader Protection Mode"]
    #[inline(always)]
    pub fn blb1(&self) -> BLB1_R {
        BLB1_R::new(((self.bits >> 4) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Memory Lock"]
    #[inline(always)]
    pub fn lb(&mut self) -> LB_W {
        LB_W { w: self }
    }
    #[doc = "Bits 2:3 - Boot Loader Protection Mode"]
    #[inline(always)]
    pub fn blb0(&mut self) -> BLB0_W {
        BLB0_W { w: self }
    }
    #[doc = "Bits 4:5 - Boot Loader Protection Mode"]
    #[inline(always)]
    pub fn blb1(&mut self) -> BLB1_W {
        BLB1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lockbit](index.html) module"]
pub struct LOCKBIT_SPEC;
impl crate::RegisterSpec for LOCKBIT_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [lockbit::R](R) reader structure"]
impl crate::Readable for LOCKBIT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lockbit::W](W) writer structure"]
impl crate::Writable for LOCKBIT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LOCKBIT to value 0"]
impl crate::Resettable for LOCKBIT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
