#[doc = "Register `OCDR` reader"]
pub struct R(crate::R<OCDR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<OCDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<OCDR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<OCDR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `OCDR` writer"]
pub struct W(crate::W<OCDR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<OCDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<OCDR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<OCDR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `OCDR` reader - On-Chip Debug Register Bits"]
pub struct OCDR_R(crate::FieldReader<u8, u8>);
impl OCDR_R {
    pub(crate) fn new(bits: u8) -> Self {
        OCDR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCDR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCDR` writer - On-Chip Debug Register Bits"]
pub struct OCDR_W<'a> {
    w: &'a mut W,
}
impl<'a> OCDR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - On-Chip Debug Register Bits"]
    #[inline(always)]
    pub fn ocdr(&self) -> OCDR_R {
        OCDR_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - On-Chip Debug Register Bits"]
    #[inline(always)]
    pub fn ocdr(&mut self) -> OCDR_W {
        OCDR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "On-Chip Debug Related Register in I/O Memory\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ocdr](index.html) module"]
pub struct OCDR_SPEC;
impl crate::RegisterSpec for OCDR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ocdr::R](R) reader structure"]
impl crate::Readable for OCDR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ocdr::W](W) writer structure"]
impl crate::Writable for OCDR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets OCDR to value 0"]
impl crate::Resettable for OCDR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
