#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - On-Chip Debug Related Register in I/O Memory"]
    pub ocdr: crate::Reg<ocdr::OCDR_SPEC>,
    _reserved1: [u8; 0x11],
    #[doc = "0x12 - MCU Control And Status Register"]
    pub mcucsr: crate::Reg<mcucsr::MCUCSR_SPEC>,
}
#[doc = "MCUCSR register accessor: an alias for `Reg<MCUCSR_SPEC>`"]
pub type MCUCSR = crate::Reg<mcucsr::MCUCSR_SPEC>;
#[doc = "MCU Control And Status Register"]
pub mod mcucsr;
#[doc = "OCDR register accessor: an alias for `Reg<OCDR_SPEC>`"]
pub type OCDR = crate::Reg<ocdr::OCDR_SPEC>;
#[doc = "On-Chip Debug Related Register in I/O Memory"]
pub mod ocdr;
