#[doc = "Register `XDIV` reader"]
pub struct R(crate::R<XDIV_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<XDIV_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<XDIV_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<XDIV_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `XDIV` writer"]
pub struct W(crate::W<XDIV_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<XDIV_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<XDIV_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<XDIV_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `XDIV` reader - XTAl Divide Select Bits"]
pub struct XDIV_R(crate::FieldReader<u8, u8>);
impl XDIV_R {
    pub(crate) fn new(bits: u8) -> Self {
        XDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XDIV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XDIV` writer - XTAl Divide Select Bits"]
pub struct XDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> XDIV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x7f) | (value as u8 & 0x7f);
        self.w
    }
}
#[doc = "Field `XDIVEN` reader - XTAL Divide Enable"]
pub struct XDIVEN_R(crate::FieldReader<bool, bool>);
impl XDIVEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        XDIVEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XDIVEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XDIVEN` writer - XTAL Divide Enable"]
pub struct XDIVEN_W<'a> {
    w: &'a mut W,
}
impl<'a> XDIVEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:6 - XTAl Divide Select Bits"]
    #[inline(always)]
    pub fn xdiv(&self) -> XDIV_R {
        XDIV_R::new((self.bits & 0x7f) as u8)
    }
    #[doc = "Bit 7 - XTAL Divide Enable"]
    #[inline(always)]
    pub fn xdiven(&self) -> XDIVEN_R {
        XDIVEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:6 - XTAl Divide Select Bits"]
    #[inline(always)]
    pub fn xdiv(&mut self) -> XDIV_W {
        XDIV_W { w: self }
    }
    #[doc = "Bit 7 - XTAL Divide Enable"]
    #[inline(always)]
    pub fn xdiven(&mut self) -> XDIVEN_W {
        XDIVEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "XTAL Divide Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [xdiv](index.html) module"]
pub struct XDIV_SPEC;
impl crate::RegisterSpec for XDIV_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [xdiv::R](R) reader structure"]
impl crate::Readable for XDIV_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [xdiv::W](W) writer structure"]
impl crate::Writable for XDIV_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets XDIV to value 0"]
impl crate::Resettable for XDIV_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
