#[doc = "Register `MCUCSR` reader"]
pub struct R(crate::R<MCUCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCUCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCUCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCUCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCUCSR` writer"]
pub struct W(crate::W<MCUCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCUCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCUCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCUCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PORF` reader - Power-on reset flag"]
pub struct PORF_R(crate::FieldReader<bool, bool>);
impl PORF_R {
    pub(crate) fn new(bits: bool) -> Self {
        PORF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PORF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PORF` writer - Power-on reset flag"]
pub struct PORF_W<'a> {
    w: &'a mut W,
}
impl<'a> PORF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `EXTRF` reader - External Reset Flag"]
pub struct EXTRF_R(crate::FieldReader<bool, bool>);
impl EXTRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        EXTRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTRF` writer - External Reset Flag"]
pub struct EXTRF_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `BORF` reader - Brown-out Reset Flag"]
pub struct BORF_R(crate::FieldReader<bool, bool>);
impl BORF_R {
    pub(crate) fn new(bits: bool) -> Self {
        BORF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BORF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BORF` writer - Brown-out Reset Flag"]
pub struct BORF_W<'a> {
    w: &'a mut W,
}
impl<'a> BORF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `WDRF` reader - Watchdog Reset Flag"]
pub struct WDRF_R(crate::FieldReader<bool, bool>);
impl WDRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDRF` writer - Watchdog Reset Flag"]
pub struct WDRF_W<'a> {
    w: &'a mut W,
}
impl<'a> WDRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `JTRF` reader - JTAG Reset Flag"]
pub struct JTRF_R(crate::FieldReader<bool, bool>);
impl JTRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        JTRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for JTRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `JTRF` writer - JTAG Reset Flag"]
pub struct JTRF_W<'a> {
    w: &'a mut W,
}
impl<'a> JTRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `JTD` reader - JTAG Interface Disable"]
pub struct JTD_R(crate::FieldReader<bool, bool>);
impl JTD_R {
    pub(crate) fn new(bits: bool) -> Self {
        JTD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for JTD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `JTD` writer - JTAG Interface Disable"]
pub struct JTD_W<'a> {
    w: &'a mut W,
}
impl<'a> JTD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Power-on reset flag"]
    #[inline(always)]
    pub fn porf(&self) -> PORF_R {
        PORF_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - External Reset Flag"]
    #[inline(always)]
    pub fn extrf(&self) -> EXTRF_R {
        EXTRF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Brown-out Reset Flag"]
    #[inline(always)]
    pub fn borf(&self) -> BORF_R {
        BORF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Watchdog Reset Flag"]
    #[inline(always)]
    pub fn wdrf(&self) -> WDRF_R {
        WDRF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - JTAG Reset Flag"]
    #[inline(always)]
    pub fn jtrf(&self) -> JTRF_R {
        JTRF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 7 - JTAG Interface Disable"]
    #[inline(always)]
    pub fn jtd(&self) -> JTD_R {
        JTD_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Power-on reset flag"]
    #[inline(always)]
    pub fn porf(&mut self) -> PORF_W {
        PORF_W { w: self }
    }
    #[doc = "Bit 1 - External Reset Flag"]
    #[inline(always)]
    pub fn extrf(&mut self) -> EXTRF_W {
        EXTRF_W { w: self }
    }
    #[doc = "Bit 2 - Brown-out Reset Flag"]
    #[inline(always)]
    pub fn borf(&mut self) -> BORF_W {
        BORF_W { w: self }
    }
    #[doc = "Bit 3 - Watchdog Reset Flag"]
    #[inline(always)]
    pub fn wdrf(&mut self) -> WDRF_W {
        WDRF_W { w: self }
    }
    #[doc = "Bit 4 - JTAG Reset Flag"]
    #[inline(always)]
    pub fn jtrf(&mut self) -> JTRF_W {
        JTRF_W { w: self }
    }
    #[doc = "Bit 7 - JTAG Interface Disable"]
    #[inline(always)]
    pub fn jtd(&mut self) -> JTD_W {
        JTD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "MCU Control And Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mcucsr](index.html) module"]
pub struct MCUCSR_SPEC;
impl crate::RegisterSpec for MCUCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mcucsr::R](R) reader structure"]
impl crate::Readable for MCUCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mcucsr::W](W) writer structure"]
impl crate::Writable for MCUCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCUCSR to value 0"]
impl crate::Resettable for MCUCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
