#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - MCU Control And Status Register"]
    pub mcucsr: crate::Reg<mcucsr::MCUCSR_SPEC>,
    #[doc = "0x01 - MCU Control Register"]
    pub mcucr: crate::Reg<mcucr::MCUCR_SPEC>,
    _reserved2: [u8; 0x06],
    #[doc = "0x08 - XTAL Divide Control Register"]
    pub xdiv: crate::Reg<xdiv::XDIV_SPEC>,
    _reserved3: [u8; 0x0f],
    #[doc = "0x18 - External Memory Control Register B"]
    pub xmcrb: crate::Reg<xmcrb::XMCRB_SPEC>,
    #[doc = "0x19 - External Memory Control Register A"]
    pub xmcra: crate::Reg<xmcra::XMCRA_SPEC>,
    _reserved5: [u8; 0x01],
    #[doc = "0x1b - Oscillator Calibration Value"]
    pub osccal: crate::Reg<osccal::OSCCAL_SPEC>,
}
#[doc = "MCUCR register accessor: an alias for `Reg<MCUCR_SPEC>`"]
pub type MCUCR = crate::Reg<mcucr::MCUCR_SPEC>;
#[doc = "MCU Control Register"]
pub mod mcucr;
#[doc = "MCUCSR register accessor: an alias for `Reg<MCUCSR_SPEC>`"]
pub type MCUCSR = crate::Reg<mcucsr::MCUCSR_SPEC>;
#[doc = "MCU Control And Status Register"]
pub mod mcucsr;
#[doc = "OSCCAL register accessor: an alias for `Reg<OSCCAL_SPEC>`"]
pub type OSCCAL = crate::Reg<osccal::OSCCAL_SPEC>;
#[doc = "Oscillator Calibration Value"]
pub mod osccal;
#[doc = "XDIV register accessor: an alias for `Reg<XDIV_SPEC>`"]
pub type XDIV = crate::Reg<xdiv::XDIV_SPEC>;
#[doc = "XTAL Divide Control Register"]
pub mod xdiv;
#[doc = "XMCRA register accessor: an alias for `Reg<XMCRA_SPEC>`"]
pub type XMCRA = crate::Reg<xmcra::XMCRA_SPEC>;
#[doc = "External Memory Control Register A"]
pub mod xmcra;
#[doc = "XMCRB register accessor: an alias for `Reg<XMCRB_SPEC>`"]
pub type XMCRB = crate::Reg<xmcrb::XMCRB_SPEC>;
#[doc = "External Memory Control Register B"]
pub mod xmcrb;
