#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - ADC Data Register Bytes"]
    pub adc: crate::Reg<adc::ADC_SPEC>,
    #[doc = "0x02 - The ADC Control and Status register A"]
    pub adcsra: crate::Reg<adcsra::ADCSRA_SPEC>,
    #[doc = "0x03 - The ADC multiplexer Selection Register"]
    pub admux: crate::Reg<admux::ADMUX_SPEC>,
    _reserved3: [u8; 0x66],
    #[doc = "0x6a - The ADC Control and Status register B"]
    pub adcsrb: crate::Reg<adcsrb::ADCSRB_SPEC>,
}
#[doc = "ADC register accessor: an alias for `Reg<ADC_SPEC>`"]
pub type ADC = crate::Reg<adc::ADC_SPEC>;
#[doc = "ADC Data Register Bytes"]
pub mod adc;
#[doc = "ADCSRA register accessor: an alias for `Reg<ADCSRA_SPEC>`"]
pub type ADCSRA = crate::Reg<adcsra::ADCSRA_SPEC>;
#[doc = "The ADC Control and Status register A"]
pub mod adcsra;
#[doc = "ADCSRB register accessor: an alias for `Reg<ADCSRB_SPEC>`"]
pub type ADCSRB = crate::Reg<adcsrb::ADCSRB_SPEC>;
#[doc = "The ADC Control and Status register B"]
pub mod adcsrb;
#[doc = "ADMUX register accessor: an alias for `Reg<ADMUX_SPEC>`"]
pub type ADMUX = crate::Reg<admux::ADMUX_SPEC>;
#[doc = "The ADC multiplexer Selection Register"]
pub mod admux;
