#[doc = "Register `CTRLA` reader"]
pub struct R(crate::R<CTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLA` writer"]
pub struct W(crate::W<CTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "RS485 Mode internal transmitter\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum RS485_A {
    #[doc = "0: RS485 Mode disabled"]
    OFF = 0,
    #[doc = "1: RS485 Mode External drive"]
    EXT = 1,
    #[doc = "2: RS485 Mode Internal drive"]
    INT = 2,
}
impl From<RS485_A> for u8 {
    #[inline(always)]
    fn from(variant: RS485_A) -> Self {
        variant as _
    }
}
#[doc = "Field `RS485` reader - RS485 Mode internal transmitter"]
pub struct RS485_R(crate::FieldReader<u8, RS485_A>);
impl RS485_R {
    pub(crate) fn new(bits: u8) -> Self {
        RS485_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<RS485_A> {
        match self.bits {
            0 => Some(RS485_A::OFF),
            1 => Some(RS485_A::EXT),
            2 => Some(RS485_A::INT),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `OFF`"]
    #[inline(always)]
    pub fn is_off(&self) -> bool {
        **self == RS485_A::OFF
    }
    #[doc = "Checks if the value of the field is `EXT`"]
    #[inline(always)]
    pub fn is_ext(&self) -> bool {
        **self == RS485_A::EXT
    }
    #[doc = "Checks if the value of the field is `INT`"]
    #[inline(always)]
    pub fn is_int(&self) -> bool {
        **self == RS485_A::INT
    }
}
impl core::ops::Deref for RS485_R {
    type Target = crate::FieldReader<u8, RS485_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RS485` writer - RS485 Mode internal transmitter"]
pub struct RS485_W<'a> {
    w: &'a mut W,
}
impl<'a> RS485_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: RS485_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "RS485 Mode disabled"]
    #[inline(always)]
    pub fn off(self) -> &'a mut W {
        self.variant(RS485_A::OFF)
    }
    #[doc = "RS485 Mode External drive"]
    #[inline(always)]
    pub fn ext(self) -> &'a mut W {
        self.variant(RS485_A::EXT)
    }
    #[doc = "RS485 Mode Internal drive"]
    #[inline(always)]
    pub fn int(self) -> &'a mut W {
        self.variant(RS485_A::INT)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `ABEIE` reader - Auto-baud Error Interrupt Enable"]
pub struct ABEIE_R(crate::FieldReader<bool, bool>);
impl ABEIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ABEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ABEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ABEIE` writer - Auto-baud Error Interrupt Enable"]
pub struct ABEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ABEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LBME` reader - Loop-back Mode Enable"]
pub struct LBME_R(crate::FieldReader<bool, bool>);
impl LBME_R {
    pub(crate) fn new(bits: bool) -> Self {
        LBME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LBME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LBME` writer - Loop-back Mode Enable"]
pub struct LBME_W<'a> {
    w: &'a mut W,
}
impl<'a> LBME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXSIE` reader - Receiver Start Frame Interrupt Enable"]
pub struct RXSIE_R(crate::FieldReader<bool, bool>);
impl RXSIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXSIE` writer - Receiver Start Frame Interrupt Enable"]
pub struct RXSIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXSIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `DREIE` reader - Data Register Empty Interrupt Enable"]
pub struct DREIE_R(crate::FieldReader<bool, bool>);
impl DREIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        DREIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DREIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DREIE` writer - Data Register Empty Interrupt Enable"]
pub struct DREIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DREIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE` reader - Transmit Complete Interrupt Enable"]
pub struct TXCIE_R(crate::FieldReader<bool, bool>);
impl TXCIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE` writer - Transmit Complete Interrupt Enable"]
pub struct TXCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE` reader - Receive Complete Interrupt Enable"]
pub struct RXCIE_R(crate::FieldReader<bool, bool>);
impl RXCIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE` writer - Receive Complete Interrupt Enable"]
pub struct RXCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - RS485 Mode internal transmitter"]
    #[inline(always)]
    pub fn rs485(&self) -> RS485_R {
        RS485_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Auto-baud Error Interrupt Enable"]
    #[inline(always)]
    pub fn abeie(&self) -> ABEIE_R {
        ABEIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Loop-back Mode Enable"]
    #[inline(always)]
    pub fn lbme(&self) -> LBME_R {
        LBME_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Start Frame Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie(&self) -> RXSIE_R {
        RXSIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn dreie(&self) -> DREIE_R {
        DREIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Transmit Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie(&self) -> TXCIE_R {
        TXCIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Receive Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie(&self) -> RXCIE_R {
        RXCIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - RS485 Mode internal transmitter"]
    #[inline(always)]
    pub fn rs485(&mut self) -> RS485_W {
        RS485_W { w: self }
    }
    #[doc = "Bit 2 - Auto-baud Error Interrupt Enable"]
    #[inline(always)]
    pub fn abeie(&mut self) -> ABEIE_W {
        ABEIE_W { w: self }
    }
    #[doc = "Bit 3 - Loop-back Mode Enable"]
    #[inline(always)]
    pub fn lbme(&mut self) -> LBME_W {
        LBME_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Start Frame Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie(&mut self) -> RXSIE_W {
        RXSIE_W { w: self }
    }
    #[doc = "Bit 5 - Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn dreie(&mut self) -> DREIE_W {
        DREIE_W { w: self }
    }
    #[doc = "Bit 6 - Transmit Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie(&mut self) -> TXCIE_W {
        TXCIE_W { w: self }
    }
    #[doc = "Bit 7 - Receive Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie(&mut self) -> RXCIE_W {
        RXCIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrla](index.html) module"]
pub struct CTRLA_SPEC;
impl crate::RegisterSpec for CTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrla::R](R) reader structure"]
impl crate::Readable for CTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrla::W](W) writer structure"]
impl crate::Writable for CTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLA to value 0"]
impl crate::Resettable for CTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
