#[doc = "Register `MCTRLB` reader"]
pub struct R(crate::R<MCTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCTRLB` writer"]
pub struct W(crate::W<MCTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Command\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum MCMD_A {
    #[doc = "0: No Action"]
    NOACT = 0,
    #[doc = "1: Issue Repeated Start Condition"]
    REPSTART = 1,
    #[doc = "2: Receive or Transmit Data, depending on DIR"]
    RECVTRANS = 2,
    #[doc = "3: Issue Stop Condition"]
    STOP = 3,
}
impl From<MCMD_A> for u8 {
    #[inline(always)]
    fn from(variant: MCMD_A) -> Self {
        variant as _
    }
}
#[doc = "Field `MCMD` reader - Command"]
pub struct MCMD_R(crate::FieldReader<u8, MCMD_A>);
impl MCMD_R {
    pub(crate) fn new(bits: u8) -> Self {
        MCMD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> MCMD_A {
        match self.bits {
            0 => MCMD_A::NOACT,
            1 => MCMD_A::REPSTART,
            2 => MCMD_A::RECVTRANS,
            3 => MCMD_A::STOP,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NOACT`"]
    #[inline(always)]
    pub fn is_noact(&self) -> bool {
        **self == MCMD_A::NOACT
    }
    #[doc = "Checks if the value of the field is `REPSTART`"]
    #[inline(always)]
    pub fn is_repstart(&self) -> bool {
        **self == MCMD_A::REPSTART
    }
    #[doc = "Checks if the value of the field is `RECVTRANS`"]
    #[inline(always)]
    pub fn is_recvtrans(&self) -> bool {
        **self == MCMD_A::RECVTRANS
    }
    #[doc = "Checks if the value of the field is `STOP`"]
    #[inline(always)]
    pub fn is_stop(&self) -> bool {
        **self == MCMD_A::STOP
    }
}
impl core::ops::Deref for MCMD_R {
    type Target = crate::FieldReader<u8, MCMD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MCMD` writer - Command"]
pub struct MCMD_W<'a> {
    w: &'a mut W,
}
impl<'a> MCMD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: MCMD_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No Action"]
    #[inline(always)]
    pub fn noact(self) -> &'a mut W {
        self.variant(MCMD_A::NOACT)
    }
    #[doc = "Issue Repeated Start Condition"]
    #[inline(always)]
    pub fn repstart(self) -> &'a mut W {
        self.variant(MCMD_A::REPSTART)
    }
    #[doc = "Receive or Transmit Data, depending on DIR"]
    #[inline(always)]
    pub fn recvtrans(self) -> &'a mut W {
        self.variant(MCMD_A::RECVTRANS)
    }
    #[doc = "Issue Stop Condition"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(MCMD_A::STOP)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Acknowledge Action\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum ACKACT_A {
    #[doc = "0: Send ACK"]
    ACK = 0,
    #[doc = "1: Send NACK"]
    NACK = 1,
}
impl From<ACKACT_A> for bool {
    #[inline(always)]
    fn from(variant: ACKACT_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `ACKACT` reader - Acknowledge Action"]
pub struct ACKACT_R(crate::FieldReader<bool, ACKACT_A>);
impl ACKACT_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACKACT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ACKACT_A {
        match self.bits {
            false => ACKACT_A::ACK,
            true => ACKACT_A::NACK,
        }
    }
    #[doc = "Checks if the value of the field is `ACK`"]
    #[inline(always)]
    pub fn is_ack(&self) -> bool {
        **self == ACKACT_A::ACK
    }
    #[doc = "Checks if the value of the field is `NACK`"]
    #[inline(always)]
    pub fn is_nack(&self) -> bool {
        **self == ACKACT_A::NACK
    }
}
impl core::ops::Deref for ACKACT_R {
    type Target = crate::FieldReader<bool, ACKACT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACKACT` writer - Acknowledge Action"]
pub struct ACKACT_W<'a> {
    w: &'a mut W,
}
impl<'a> ACKACT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ACKACT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Send ACK"]
    #[inline(always)]
    pub fn ack(self) -> &'a mut W {
        self.variant(ACKACT_A::ACK)
    }
    #[doc = "Send NACK"]
    #[inline(always)]
    pub fn nack(self) -> &'a mut W {
        self.variant(ACKACT_A::NACK)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FLUSH` reader - Flush"]
pub struct FLUSH_R(crate::FieldReader<bool, bool>);
impl FLUSH_R {
    pub(crate) fn new(bits: bool) -> Self {
        FLUSH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FLUSH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FLUSH` writer - Flush"]
pub struct FLUSH_W<'a> {
    w: &'a mut W,
}
impl<'a> FLUSH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Command"]
    #[inline(always)]
    pub fn mcmd(&self) -> MCMD_R {
        MCMD_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Acknowledge Action"]
    #[inline(always)]
    pub fn ackact(&self) -> ACKACT_R {
        ACKACT_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Flush"]
    #[inline(always)]
    pub fn flush(&self) -> FLUSH_R {
        FLUSH_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Command"]
    #[inline(always)]
    pub fn mcmd(&mut self) -> MCMD_W {
        MCMD_W { w: self }
    }
    #[doc = "Bit 2 - Acknowledge Action"]
    #[inline(always)]
    pub fn ackact(&mut self) -> ACKACT_W {
        ACKACT_W { w: self }
    }
    #[doc = "Bit 3 - Flush"]
    #[inline(always)]
    pub fn flush(&mut self) -> FLUSH_W {
        FLUSH_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Master Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mctrlb](index.html) module"]
pub struct MCTRLB_SPEC;
impl crate::RegisterSpec for MCTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mctrlb::R](R) reader structure"]
impl crate::Readable for MCTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mctrlb::W](W) writer structure"]
impl crate::Writable for MCTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCTRLB to value 0"]
impl crate::Resettable for MCTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
