#[doc = "Register `MCTRLA` reader"]
pub struct R(crate::R<MCTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCTRLA` writer"]
pub struct W(crate::W<MCTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ENABLE` reader - Enable TWI Master"]
pub struct ENABLE_R(crate::FieldReader<bool, bool>);
impl ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENABLE` writer - Enable TWI Master"]
pub struct ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `SMEN` reader - Smart Mode Enable"]
pub struct SMEN_R(crate::FieldReader<bool, bool>);
impl SMEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SMEN` writer - Smart Mode Enable"]
pub struct SMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Inactive Bus Timeout\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum TIMEOUT_A {
    #[doc = "0: Bus Timeout Disabled"]
    DISABLED = 0,
    #[doc = "1: 50 Microseconds"]
    _50US = 1,
    #[doc = "2: 100 Microseconds"]
    _100US = 2,
    #[doc = "3: 200 Microseconds"]
    _200US = 3,
}
impl From<TIMEOUT_A> for u8 {
    #[inline(always)]
    fn from(variant: TIMEOUT_A) -> Self {
        variant as _
    }
}
#[doc = "Field `TIMEOUT` reader - Inactive Bus Timeout"]
pub struct TIMEOUT_R(crate::FieldReader<u8, TIMEOUT_A>);
impl TIMEOUT_R {
    pub(crate) fn new(bits: u8) -> Self {
        TIMEOUT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TIMEOUT_A {
        match self.bits {
            0 => TIMEOUT_A::DISABLED,
            1 => TIMEOUT_A::_50US,
            2 => TIMEOUT_A::_100US,
            3 => TIMEOUT_A::_200US,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == TIMEOUT_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `_50US`"]
    #[inline(always)]
    pub fn is_50us(&self) -> bool {
        **self == TIMEOUT_A::_50US
    }
    #[doc = "Checks if the value of the field is `_100US`"]
    #[inline(always)]
    pub fn is_100us(&self) -> bool {
        **self == TIMEOUT_A::_100US
    }
    #[doc = "Checks if the value of the field is `_200US`"]
    #[inline(always)]
    pub fn is_200us(&self) -> bool {
        **self == TIMEOUT_A::_200US
    }
}
impl core::ops::Deref for TIMEOUT_R {
    type Target = crate::FieldReader<u8, TIMEOUT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMEOUT` writer - Inactive Bus Timeout"]
pub struct TIMEOUT_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMEOUT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMEOUT_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Bus Timeout Disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(TIMEOUT_A::DISABLED)
    }
    #[doc = "50 Microseconds"]
    #[inline(always)]
    pub fn _50us(self) -> &'a mut W {
        self.variant(TIMEOUT_A::_50US)
    }
    #[doc = "100 Microseconds"]
    #[inline(always)]
    pub fn _100us(self) -> &'a mut W {
        self.variant(TIMEOUT_A::_100US)
    }
    #[doc = "200 Microseconds"]
    #[inline(always)]
    pub fn _200us(self) -> &'a mut W {
        self.variant(TIMEOUT_A::_200US)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `QCEN` reader - Quick Command Enable"]
pub struct QCEN_R(crate::FieldReader<bool, bool>);
impl QCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        QCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for QCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `QCEN` writer - Quick Command Enable"]
pub struct QCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> QCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `WIEN` reader - Write Interrupt Enable"]
pub struct WIEN_R(crate::FieldReader<bool, bool>);
impl WIEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        WIEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WIEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WIEN` writer - Write Interrupt Enable"]
pub struct WIEN_W<'a> {
    w: &'a mut W,
}
impl<'a> WIEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RIEN` reader - Read Interrupt Enable"]
pub struct RIEN_R(crate::FieldReader<bool, bool>);
impl RIEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RIEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RIEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RIEN` writer - Read Interrupt Enable"]
pub struct RIEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RIEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable TWI Master"]
    #[inline(always)]
    pub fn enable(&self) -> ENABLE_R {
        ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Smart Mode Enable"]
    #[inline(always)]
    pub fn smen(&self) -> SMEN_R {
        SMEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:3 - Inactive Bus Timeout"]
    #[inline(always)]
    pub fn timeout(&self) -> TIMEOUT_R {
        TIMEOUT_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 4 - Quick Command Enable"]
    #[inline(always)]
    pub fn qcen(&self) -> QCEN_R {
        QCEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Write Interrupt Enable"]
    #[inline(always)]
    pub fn wien(&self) -> WIEN_R {
        WIEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Read Interrupt Enable"]
    #[inline(always)]
    pub fn rien(&self) -> RIEN_R {
        RIEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Enable TWI Master"]
    #[inline(always)]
    pub fn enable(&mut self) -> ENABLE_W {
        ENABLE_W { w: self }
    }
    #[doc = "Bit 1 - Smart Mode Enable"]
    #[inline(always)]
    pub fn smen(&mut self) -> SMEN_W {
        SMEN_W { w: self }
    }
    #[doc = "Bits 2:3 - Inactive Bus Timeout"]
    #[inline(always)]
    pub fn timeout(&mut self) -> TIMEOUT_W {
        TIMEOUT_W { w: self }
    }
    #[doc = "Bit 4 - Quick Command Enable"]
    #[inline(always)]
    pub fn qcen(&mut self) -> QCEN_W {
        QCEN_W { w: self }
    }
    #[doc = "Bit 6 - Write Interrupt Enable"]
    #[inline(always)]
    pub fn wien(&mut self) -> WIEN_W {
        WIEN_W { w: self }
    }
    #[doc = "Bit 7 - Read Interrupt Enable"]
    #[inline(always)]
    pub fn rien(&mut self) -> RIEN_W {
        RIEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Master Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mctrla](index.html) module"]
pub struct MCTRLA_SPEC;
impl crate::RegisterSpec for MCTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mctrla::R](R) reader structure"]
impl crate::Readable for MCTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mctrla::W](W) writer structure"]
impl crate::Writable for MCTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCTRLA to value 0"]
impl crate::Resettable for MCTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
