#[doc = "Register `STATUS` reader"]
pub struct R(crate::R<STATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<STATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<STATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `CTRLABUSY` reader - CTRLA Synchronization Busy Flag"]
pub struct CTRLABUSY_R(crate::FieldReader<bool, bool>);
impl CTRLABUSY_R {
    pub(crate) fn new(bits: bool) -> Self {
        CTRLABUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTRLABUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNTBUSY` reader - Count Synchronization Busy Flag"]
pub struct CNTBUSY_R(crate::FieldReader<bool, bool>);
impl CNTBUSY_R {
    pub(crate) fn new(bits: bool) -> Self {
        CNTBUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CNTBUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PERBUSY` reader - Period Synchronization Busy Flag"]
pub struct PERBUSY_R(crate::FieldReader<bool, bool>);
impl PERBUSY_R {
    pub(crate) fn new(bits: bool) -> Self {
        PERBUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PERBUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPBUSY` reader - Comparator Synchronization Busy Flag"]
pub struct CMPBUSY_R(crate::FieldReader<bool, bool>);
impl CMPBUSY_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPBUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPBUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - CTRLA Synchronization Busy Flag"]
    #[inline(always)]
    pub fn ctrlabusy(&self) -> CTRLABUSY_R {
        CTRLABUSY_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Count Synchronization Busy Flag"]
    #[inline(always)]
    pub fn cntbusy(&self) -> CNTBUSY_R {
        CNTBUSY_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Period Synchronization Busy Flag"]
    #[inline(always)]
    pub fn perbusy(&self) -> PERBUSY_R {
        PERBUSY_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Comparator Synchronization Busy Flag"]
    #[inline(always)]
    pub fn cmpbusy(&self) -> CMPBUSY_R {
        CMPBUSY_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
#[doc = "Status\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [status](index.html) module"]
pub struct STATUS_SPEC;
impl crate::RegisterSpec for STATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [status::R](R) reader structure"]
impl crate::Readable for STATUS_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets STATUS to value 0"]
impl crate::Resettable for STATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
