#[doc = "Register `CCLROUTEA` reader"]
pub struct R(crate::R<CCLROUTEA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CCLROUTEA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CCLROUTEA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CCLROUTEA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CCLROUTEA` writer"]
pub struct W(crate::W<CCLROUTEA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CCLROUTEA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CCLROUTEA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CCLROUTEA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LUT0` reader - CCL LUT0"]
pub struct LUT0_R(crate::FieldReader<bool, bool>);
impl LUT0_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LUT0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT0` writer - CCL LUT0"]
pub struct LUT0_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `LUT1` reader - CCL LUT1"]
pub struct LUT1_R(crate::FieldReader<bool, bool>);
impl LUT1_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LUT1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT1` writer - CCL LUT1"]
pub struct LUT1_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LUT2` reader - CCL LUT2"]
pub struct LUT2_R(crate::FieldReader<bool, bool>);
impl LUT2_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LUT2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT2` writer - CCL LUT2"]
pub struct LUT2_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LUT3` reader - CCL LUT3"]
pub struct LUT3_R(crate::FieldReader<bool, bool>);
impl LUT3_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LUT3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT3` writer - CCL LUT3"]
pub struct LUT3_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - CCL LUT0"]
    #[inline(always)]
    pub fn lut0(&self) -> LUT0_R {
        LUT0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - CCL LUT1"]
    #[inline(always)]
    pub fn lut1(&self) -> LUT1_R {
        LUT1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - CCL LUT2"]
    #[inline(always)]
    pub fn lut2(&self) -> LUT2_R {
        LUT2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - CCL LUT3"]
    #[inline(always)]
    pub fn lut3(&self) -> LUT3_R {
        LUT3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - CCL LUT0"]
    #[inline(always)]
    pub fn lut0(&mut self) -> LUT0_W {
        LUT0_W { w: self }
    }
    #[doc = "Bit 1 - CCL LUT1"]
    #[inline(always)]
    pub fn lut1(&mut self) -> LUT1_W {
        LUT1_W { w: self }
    }
    #[doc = "Bit 2 - CCL LUT2"]
    #[inline(always)]
    pub fn lut2(&mut self) -> LUT2_W {
        LUT2_W { w: self }
    }
    #[doc = "Bit 3 - CCL LUT3"]
    #[inline(always)]
    pub fn lut3(&mut self) -> LUT3_W {
        LUT3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port Multiplexer CCL\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cclroutea](index.html) module"]
pub struct CCLROUTEA_SPEC;
impl crate::RegisterSpec for CCLROUTEA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [cclroutea::R](R) reader structure"]
impl crate::Readable for CCLROUTEA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cclroutea::W](W) writer structure"]
impl crate::Writable for CCLROUTEA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CCLROUTEA to value 0"]
impl crate::Resettable for CCLROUTEA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
