#[doc = "Register `PORTCTRL` reader"]
pub struct R(crate::R<PORTCTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PORTCTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PORTCTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PORTCTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PORTCTRL` writer"]
pub struct W(crate::W<PORTCTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PORTCTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PORTCTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PORTCTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SRL` reader - Slew Rate Limit Enable"]
pub struct SRL_R(crate::FieldReader<bool, bool>);
impl SRL_R {
    pub(crate) fn new(bits: bool) -> Self {
        SRL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRL` writer - Slew Rate Limit Enable"]
pub struct SRL_W<'a> {
    w: &'a mut W,
}
impl<'a> SRL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Slew Rate Limit Enable"]
    #[inline(always)]
    pub fn srl(&self) -> SRL_R {
        SRL_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Slew Rate Limit Enable"]
    #[inline(always)]
    pub fn srl(&mut self) -> SRL_W {
        SRL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port Control\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [portctrl](index.html) module"]
pub struct PORTCTRL_SPEC;
impl crate::RegisterSpec for PORTCTRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [portctrl::R](R) reader structure"]
impl crate::Readable for PORTCTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [portctrl::W](W) writer structure"]
impl crate::Writable for PORTCTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PORTCTRL to value 0"]
impl crate::Resettable for PORTCTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
